/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.action;

import java.time.ZoneId;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.ElasticsearchClient;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.xpack.sql.action.Protocol;
import org.elasticsearch.xpack.sql.action.SqlTranslateAction;
import org.elasticsearch.xpack.sql.action.SqlTranslateRequest;
import org.elasticsearch.xpack.sql.action.SqlTranslateResponse;
import org.elasticsearch.xpack.sql.proto.Mode;
import org.elasticsearch.xpack.sql.proto.RequestInfo;
import org.elasticsearch.xpack.sql.proto.SqlTypedParamValue;

public class SqlTranslateRequestBuilder
extends ActionRequestBuilder<SqlTranslateRequest, SqlTranslateResponse> {
    public SqlTranslateRequestBuilder(ElasticsearchClient client) {
        this(client, null, null, Collections.emptyMap(), Collections.emptyList(), Protocol.TIME_ZONE, 1000, Protocol.REQUEST_TIMEOUT, Protocol.PAGE_TIMEOUT, new RequestInfo(Mode.PLAIN));
    }

    public SqlTranslateRequestBuilder(ElasticsearchClient client, String query, QueryBuilder filter, Map<String, Object> runtimeMappings, List<SqlTypedParamValue> params, ZoneId zoneId, int fetchSize, TimeValue requestTimeout, TimeValue pageTimeout, RequestInfo requestInfo) {
        super(client, (ActionType)SqlTranslateAction.INSTANCE, (ActionRequest)new SqlTranslateRequest(query, params, filter, runtimeMappings, zoneId, fetchSize, requestTimeout, pageTimeout, requestInfo));
    }

    public SqlTranslateRequestBuilder query(String query) {
        ((SqlTranslateRequest)this.request).query(query);
        return this;
    }

    public SqlTranslateRequestBuilder zoneId(ZoneId zoneId) {
        ((SqlTranslateRequest)this.request).zoneId(zoneId);
        return this;
    }
}

