/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.netio;

import java.util.ArrayList;
import java.util.List;
import org.ojalgo.netio.LineTerminator;

public final class DelimitedData {
    private final char myDelimiter;
    private final List<List<Object>> myLines;
    private final LineTerminator myTerminator;

    public static DelimitedData makeCommaDelimited() {
        return new DelimitedData(',', LineTerminator.WINDOWS);
    }

    public static DelimitedData makeSemicolonDelimited() {
        return new DelimitedData(';', LineTerminator.WINDOWS);
    }

    public static DelimitedData makeSpaceDelimited() {
        return new DelimitedData(' ', LineTerminator.WINDOWS);
    }

    public static DelimitedData makeTabDelimited() {
        return new DelimitedData('\t', LineTerminator.WINDOWS);
    }

    public DelimitedData(char aDelimiter, LineTerminator aTerminator) {
        this.myDelimiter = aDelimiter;
        this.myTerminator = aTerminator;
        this.myLines = new ArrayList<List<Object>>();
    }

    public void addEmptyLines(int aNumberOfLines, int aNumberOfElementsOnEachLine) {
        for (int i = 0; i < aNumberOfLines; ++i) {
            this.myLines.add(new ArrayList(aNumberOfElementsOnEachLine));
        }
    }

    public void addLine(List<?> aLine) {
        this.myLines.add(aLine);
    }

    public void set(int aRowIndex, int aColumnIndex, Object anElement) {
        this.myLines.get(aRowIndex).set(aColumnIndex, anElement);
    }

    public String toString() {
        StringBuilder retVal = new StringBuilder();
        for (List<Object> tmpLine : this.myLines) {
            for (Object tmpElement : tmpLine) {
                if (tmpElement != null) {
                    retVal.append(tmpElement);
                }
                retVal.append(this.myDelimiter);
            }
            retVal.append((Object)this.myTerminator);
        }
        return retVal.toString();
    }
}

