/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store;

import java.util.List;
import org.ojalgo.array.DenseArray;
import org.ojalgo.array.operation.AMAX;
import org.ojalgo.function.FunctionSet;
import org.ojalgo.function.NullaryFunction;
import org.ojalgo.function.aggregator.AggregatorSet;
import org.ojalgo.matrix.store.ColumnsSupplier;
import org.ojalgo.matrix.store.DiagonalStore;
import org.ojalgo.matrix.store.IdentityStore;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.RowsSupplier;
import org.ojalgo.matrix.store.SingleStore;
import org.ojalgo.matrix.store.SparseStore;
import org.ojalgo.matrix.store.TransformableRegion;
import org.ojalgo.matrix.store.WrapperStore;
import org.ojalgo.matrix.store.ZeroStore;
import org.ojalgo.matrix.transformation.Householder;
import org.ojalgo.matrix.transformation.Rotation;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.structure.Access1D;
import org.ojalgo.structure.Access2D;
import org.ojalgo.structure.Factory2D;
import org.ojalgo.structure.Structure2D;
import org.ojalgo.structure.Transformation2D;
import org.ojalgo.tensor.TensorFactory1D;
import org.ojalgo.tensor.TensorFactory2D;

public interface PhysicalStore<N extends Comparable<N>>
extends MatrixStore<N>,
TransformableRegion<N> {
    public List<N> asList();

    @Override
    default public void modifyAny(Transformation2D<N> modifier) {
        modifier.transform(this);
    }

    public void substituteBackwards(Access2D<N> var1, boolean var2, boolean var3, boolean var4);

    public void substituteForwards(Access2D<N> var1, boolean var2, boolean var3, boolean var4);

    @Override
    default public void supplyTo(TransformableRegion<N> receiver) {
        if (this != receiver) {
            receiver.fillMatching(this);
        }
    }

    public void transformLeft(Householder<N> var1, int var2);

    public void transformLeft(Rotation<N> var1);

    public void transformRight(Householder<N> var1, int var2);

    public void transformRight(Rotation<N> var1);

    default public int indexOfLargestInColumn(int row, int col) {
        long structure = this.countRows();
        long first = Structure2D.index(structure, row, col);
        long limit = Structure2D.index(structure, 0L, (long)col + 1L);
        long step = 1L;
        long largest = AMAX.invoke(this, first, limit, step);
        return Math.toIntExact(largest % structure);
    }

    default public int indexOfLargestInRow(int row, int col) {
        long structure = this.countRows();
        long first = Structure2D.index(structure, row, col);
        long limit = Structure2D.index(structure, 0L, this.countColumns());
        long step = structure;
        long largest = AMAX.invoke(this, first, limit, step);
        return Math.toIntExact(largest / structure);
    }

    default public int indexOfLargestOnDiagonal(int row, int col) {
        long structure = this.countRows();
        long first = Structure2D.index(structure, row, col);
        long limit = Structure2D.index(structure, 0L, this.countColumns());
        long step = structure + 1L;
        long largest = AMAX.invoke(this, first, limit, step);
        return Math.toIntExact(largest / structure);
    }

    public static interface Factory<N extends Comparable<N>, I extends PhysicalStore<N>>
    extends Factory2D.Dense<I>,
    Factory2D.MayBeSparse<I, PhysicalStore<N>, SparseStore<N>> {
        public AggregatorSet<N> aggregator();

        public DenseArray.Factory<N> array();

        @Deprecated
        default public Factory<N, I> builder() {
            return this;
        }

        public I conjugate(Access2D<?> var1);

        public FunctionSet<N> function();

        default public ColumnsSupplier<N> makeColumnsSupplier(int numberOfRows) {
            return new ColumnsSupplier(this, numberOfRows);
        }

        @Override
        default public PhysicalStore<N> makeDense(long rows, long columns) {
            return (PhysicalStore)this.make(rows, columns);
        }

        default public <D extends Access1D<?>> DiagonalStore.Builder<N, D> makeDiagonal(D mainDiagonal) {
            return DiagonalStore.builder(this, mainDiagonal);
        }

        default public I makeEye(long rows, long columns) {
            PhysicalStore retVal = (PhysicalStore)this.make(rows, columns);
            Comparable tmpVal = (Comparable)this.scalar().one().get();
            retVal.fillDiagonal(tmpVal);
            return (I)retVal;
        }

        default public I makeEye(Structure2D shape) {
            return this.makeEye(shape.countRows(), shape.countColumns());
        }

        @Override
        default public I makeFilled(long rows, long columns, NullaryFunction<?> supplier) {
            PhysicalStore retVal = (PhysicalStore)this.make(rows, columns);
            retVal.fillAll(supplier);
            return (I)retVal;
        }

        public Householder<N> makeHouseholder(int var1);

        default public MatrixStore<N> makeIdentity(long dimension) {
            return new IdentityStore(this, dimension);
        }

        public Rotation<N> makeRotation(int var1, int var2, double var3, double var5);

        public Rotation<N> makeRotation(int var1, int var2, N var3, N var4);

        default public RowsSupplier<N> makeRowsSupplier(int numberOfColumns) {
            return new RowsSupplier(this, numberOfColumns);
        }

        default public MatrixStore<N> makeSingle(N element) {
            return new SingleStore(this, element);
        }

        @Override
        default public SparseStore<N> makeSparse(long rowsCount, long columnsCount) {
            return SparseStore.makeSparse(this, rowsCount, columnsCount);
        }

        default public I makeSPD(int dim) {
            double[] random = new double[dim];
            PhysicalStore retVal = (PhysicalStore)this.make(dim, dim);
            for (int i = 0; i < dim; ++i) {
                random[i] = Math.random();
                for (int j = 0; j < i; ++j) {
                    retVal.set((long)i, (long)j, random[i] * random[j]);
                    retVal.set((long)j, (long)i, random[j] * random[i]);
                }
                retVal.set((long)i, (long)i, random[i] + 1.0);
            }
            return (I)retVal;
        }

        default public MatrixStore<N> makeWrapper(Access2D<?> access) {
            return new WrapperStore(this, access);
        }

        default public MatrixStore<N> makeZero(long rowsCount, long columnsCount) {
            return new ZeroStore(this, rowsCount, columnsCount);
        }

        default public MatrixStore<N> makeZero(Structure2D shape) {
            return this.makeZero(shape.countRows(), shape.countColumns());
        }

        public Scalar.Factory<N> scalar();

        default public TensorFactory1D<N, I> tensor1D() {
            return TensorFactory1D.of(this.asFactory1D());
        }

        default public TensorFactory2D<N, I> tensor2D() {
            return TensorFactory2D.of(this);
        }

        public I transpose(Access2D<?> var1);
    }
}

