/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.function.polynomial;

import org.ojalgo.array.Array1D;
import org.ojalgo.function.BasicFunction;
import org.ojalgo.function.polynomial.AbstractPolynomial;
import org.ojalgo.matrix.decomposition.QR;
import org.ojalgo.matrix.store.GenericStore;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.structure.Access1D;

public final class ComplexPolynomial
extends AbstractPolynomial<ComplexNumber> {
    public ComplexPolynomial(int degree) {
        super((Array1D)Array1D.COMPLEX.make(degree + 1));
    }

    ComplexPolynomial(Array1D<ComplexNumber> coefficients) {
        super(coefficients);
    }

    @Override
    public void estimate(Access1D<?> x, Access1D<?> y) {
        this.estimate(x, y, GenericStore.COMPLEX, QR.COMPLEX);
    }

    @Override
    public ComplexNumber integrate(ComplexNumber fromPoint, ComplexNumber toPoint) {
        BasicFunction tmpPrim = this.buildPrimitive();
        ComplexNumber tmpFromVal = tmpPrim.invoke(fromPoint);
        ComplexNumber tmpToVal = tmpPrim.invoke(toPoint);
        return tmpToVal.subtract(tmpFromVal);
    }

    @Override
    public ComplexNumber invoke(ComplexNumber arg) {
        int tmpPower = this.degree();
        ComplexNumber retVal = (ComplexNumber)this.get(tmpPower);
        while (--tmpPower >= 0) {
            retVal = ((ComplexNumber)this.get(tmpPower)).add(arg.multiply(retVal));
        }
        return retVal;
    }

    @Override
    public void set(Access1D<?> coefficients) {
        int tmpLimit = Math.min(this.size(), coefficients.size());
        for (int p = 0; p < tmpLimit; ++p) {
            this.set(p, ComplexNumber.valueOf(coefficients.get(p)));
        }
    }

    @Override
    protected ComplexNumber getDerivativeFactor(int power) {
        int tmpNextIndex = power + 1;
        return ((ComplexNumber)this.get(tmpNextIndex)).multiply(tmpNextIndex);
    }

    @Override
    protected ComplexNumber getPrimitiveFactor(int power) {
        if (power <= 0) {
            return ComplexNumber.ZERO;
        }
        return ((ComplexNumber)this.get(power - 1)).divide(power);
    }

    @Override
    protected AbstractPolynomial<ComplexNumber> makeInstance(int size) {
        return new ComplexPolynomial((Array1D)Array1D.COMPLEX.make(size));
    }
}

