/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.function;

import java.util.function.BinaryOperator;
import java.util.function.DoubleBinaryOperator;
import org.ojalgo.ProgrammingError;
import org.ojalgo.function.BasicFunction;
import org.ojalgo.function.UnaryFunction;
import org.ojalgo.type.NumberDefinition;

public interface BinaryFunction<N extends Comparable<N>>
extends BasicFunction,
BinaryOperator<N>,
DoubleBinaryOperator {
    default public BinaryFunction<N> andThen(final UnaryFunction<N> after) {
        ProgrammingError.throwIfNull(after);
        return new BinaryFunction<N>(){

            @Override
            public double invoke(double arg1, double arg2) {
                return after.invoke(BinaryFunction.this.invoke(arg1, arg2));
            }

            @Override
            public float invoke(float arg1, float arg2) {
                return after.invoke(BinaryFunction.this.invoke(arg1, arg2));
            }

            @Override
            public N invoke(N arg1, N arg2) {
                return after.invoke(BinaryFunction.this.invoke(arg1, arg2));
            }
        };
    }

    @Override
    default public N apply(N arg1, N arg2) {
        return this.invoke(arg1, arg2);
    }

    @Override
    default public double applyAsDouble(double arg1, double arg2) {
        return this.invoke(arg1, arg2);
    }

    default public UnaryFunction<N> by(double arg2) {
        return this.second((N)arg2);
    }

    default public UnaryFunction<N> by(N arg2) {
        return this.second(arg2);
    }

    default public UnaryFunction<N> first(double arg1) {
        return new FixedFirst<double>(arg1, (BinaryFunction<double>)this);
    }

    default public UnaryFunction<N> first(N arg1) {
        return new FixedFirst<N>(arg1, this);
    }

    default public byte invoke(byte arg1, byte arg2) {
        return (byte)this.invoke((double)arg1, (double)arg2);
    }

    public double invoke(double var1, double var3);

    default public float invoke(float arg1, float arg2) {
        return (float)this.invoke((double)arg1, (double)arg2);
    }

    default public int invoke(int arg1, int arg2) {
        return NumberDefinition.toInt(this.invoke((double)arg1, (double)arg2));
    }

    default public long invoke(long arg1, long arg2) {
        return NumberDefinition.toLong(this.invoke((double)arg1, (double)arg2));
    }

    public N invoke(N var1, N var2);

    default public short invoke(short arg1, short arg2) {
        return (short)this.invoke((double)arg1, (double)arg2);
    }

    default public UnaryFunction<N> second(double arg2) {
        return new FixedSecond<double>((BinaryFunction<double>)this, arg2);
    }

    default public UnaryFunction<N> second(N arg2) {
        return new FixedSecond<N>(this, arg2);
    }

    public static final class FixedSecond<N extends Comparable<N>>
    implements UnaryFunction<N> {
        private final double myDoubleValue;
        private final float myFloatValue;
        private final BinaryFunction<N> myFunction;
        private final N myNumber;

        FixedSecond(BinaryFunction<N> function, double arg2) {
            this.myFunction = function;
            this.myNumber = arg2;
            this.myDoubleValue = arg2;
            this.myFloatValue = (float)arg2;
        }

        FixedSecond(BinaryFunction<N> function, N arg2) {
            this.myFunction = function;
            this.myNumber = arg2;
            this.myDoubleValue = NumberDefinition.doubleValue(arg2);
            this.myFloatValue = NumberDefinition.floatValue(arg2);
        }

        public double doubleValue() {
            return this.myDoubleValue;
        }

        public float floatValue() {
            return this.myFloatValue;
        }

        public BinaryFunction<N> getFunction() {
            return this.myFunction;
        }

        public N getNumber() {
            return this.myNumber;
        }

        @Override
        public double invoke(double arg1) {
            return this.myFunction.invoke(arg1, this.myDoubleValue);
        }

        @Override
        public float invoke(float arg1) {
            return this.myFunction.invoke(arg1, this.myFloatValue);
        }

        @Override
        public N invoke(N arg1) {
            return this.myFunction.invoke(arg1, this.myNumber);
        }
    }

    public static final class FixedFirst<N extends Comparable<N>>
    implements UnaryFunction<N> {
        private final double myDoubleValue;
        private final float myFloatValue;
        private final BinaryFunction<N> myFunction;
        private final N myNumber;

        FixedFirst(double arg1, BinaryFunction<N> function) {
            this.myFunction = function;
            this.myNumber = arg1;
            this.myDoubleValue = arg1;
            this.myFloatValue = (float)arg1;
        }

        FixedFirst(N arg1, BinaryFunction<N> function) {
            this.myFunction = function;
            this.myNumber = arg1;
            this.myDoubleValue = NumberDefinition.doubleValue(arg1);
            this.myFloatValue = NumberDefinition.floatValue(arg1);
        }

        public double doubleValue() {
            return this.myDoubleValue;
        }

        public float floatValue() {
            return this.myFloatValue;
        }

        public BinaryFunction<N> getFunction() {
            return this.myFunction;
        }

        public N getNumber() {
            return this.myNumber;
        }

        @Override
        public double invoke(double arg2) {
            return this.myFunction.invoke(this.myDoubleValue, arg2);
        }

        @Override
        public float invoke(float arg2) {
            return this.myFunction.invoke(this.myFloatValue, arg2);
        }

        @Override
        public N invoke(N arg2) {
            return this.myFunction.invoke(this.myNumber, arg2);
        }
    }
}

