/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.LongAdder;
import org.elasticsearch.transport.TransportActionStats;

public class TransportActionStatsTracker {
    private static final int MAX_BUCKET = TransportActionStatsTracker.getBucketUpperBounds().length;
    private final StatsTracker requestStats = new StatsTracker();
    private final StatsTracker responseStats = new StatsTracker();

    public static int[] getBucketUpperBounds() {
        int[] bounds = new int[28];
        for (int i = 0; i < 28; ++i) {
            bounds[i] = 8 << i;
        }
        return bounds;
    }

    private static int bucket(int messageSize) {
        return Math.min(Math.max(29 - Integer.numberOfLeadingZeros(messageSize), 0), MAX_BUCKET);
    }

    public void addRequestStats(int messageSize) {
        this.requestStats.addStats(messageSize);
    }

    public void addResponseStats(int messageSize) {
        this.responseStats.addStats(messageSize);
    }

    public TransportActionStats getStats() {
        return new TransportActionStats(this.requestStats.count().longValue(), this.requestStats.totalSize().longValue(), this.requestStats.getHistogram(), this.responseStats.count().longValue(), this.responseStats.totalSize().longValue(), this.responseStats.getHistogram());
    }

    private record StatsTracker(LongAdder count, LongAdder totalSize, AtomicLongArray histogram) {
        StatsTracker {
            assert (count.longValue() == 0L);
            assert (totalSize.longValue() == 0L);
            assert (histogram.length() == MAX_BUCKET + 1);
        }

        StatsTracker() {
            this(new LongAdder(), new LongAdder(), new AtomicLongArray(MAX_BUCKET + 1));
        }

        void addStats(int messageSize) {
            this.count().increment();
            this.totalSize().add(messageSize);
            this.histogram().incrementAndGet(TransportActionStatsTracker.bucket(messageSize));
        }

        long[] getHistogram() {
            long[] histogramCopy = new long[MAX_BUCKET + 1];
            for (int i = 0; i <= MAX_BUCKET; ++i) {
                histogramCopy[i] = this.histogram().get(i);
            }
            return histogramCopy;
        }
    }
}

