/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.sampler;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.apache.lucene.search.CollectionTerminatedException;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopDocsCollector;
import org.apache.lucene.search.TopScoreDocCollectorManager;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.common.util.ObjectArray;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.search.aggregations.AggregationExecutionContext;
import org.elasticsearch.search.aggregations.BucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.MultiBucketCollector;
import org.elasticsearch.search.aggregations.bucket.DeferringBucketCollector;

public class BestDocsDeferringCollector
extends DeferringBucketCollector
implements Releasable {
    private final List<PerSegmentCollects> entries = new ArrayList<PerSegmentCollects>();
    private BucketCollector deferred;
    private ObjectArray<PerParentBucketSamples> perBucketSamples;
    private final int shardSize;
    private PerSegmentCollects perSegCollector;
    private final BigArrays bigArrays;
    private final Consumer<Long> circuitBreakerConsumer;
    private static final long SENTINEL_SIZE = RamUsageEstimator.shallowSizeOfInstance(Object.class);

    BestDocsDeferringCollector(int shardSize, BigArrays bigArrays, Consumer<Long> circuitBreakerConsumer) {
        this.shardSize = shardSize;
        this.bigArrays = bigArrays;
        this.circuitBreakerConsumer = circuitBreakerConsumer;
        this.perBucketSamples = bigArrays.newObjectArray(1L);
    }

    @Override
    public ScoreMode scoreMode() {
        return ScoreMode.COMPLETE;
    }

    @Override
    public void setDeferredCollector(Iterable<BucketCollector> deferredCollectors) {
        this.deferred = MultiBucketCollector.wrap(true, deferredCollectors);
    }

    @Override
    public LeafBucketCollector getLeafCollector(AggregationExecutionContext aggCtx) throws IOException {
        this.perSegCollector = new PerSegmentCollects(aggCtx);
        this.entries.add(this.perSegCollector);
        return new LeafBucketCollector(){

            @Override
            public void setScorer(Scorable scorer) throws IOException {
                BestDocsDeferringCollector.this.perSegCollector.setScorer(scorer);
            }

            @Override
            public void collect(int doc, long bucket) throws IOException {
                BestDocsDeferringCollector.this.perSegCollector.collect(doc, bucket);
            }
        };
    }

    protected TopDocsCollector<? extends ScoreDoc> createTopDocsCollector(int size) throws IOException {
        return new TopScoreDocCollectorManager(size, null, Integer.MAX_VALUE, false).newCollector();
    }

    protected long getPriorityQueueSlotSize() {
        return SENTINEL_SIZE;
    }

    @Override
    public void preCollection() throws IOException {
        this.deferred.preCollection();
    }

    @Override
    public void postCollection() throws IOException {
        this.runDeferredAggs();
    }

    @Override
    public void prepareSelectedBuckets(LongArray selectedBuckets) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runDeferredAggs() throws IOException {
        this.circuitBreakerConsumer.accept(12L * (long)this.shardSize);
        try {
            ArrayList<ScoreDoc> allDocs = new ArrayList<ScoreDoc>(this.shardSize);
            int i = 0;
            while ((long)i < this.perBucketSamples.size()) {
                PerParentBucketSamples perBucketSample = this.perBucketSamples.get(i);
                if (perBucketSample != null) {
                    perBucketSample.getMatches(allDocs);
                }
                ++i;
            }
            allDocs.sort((o1, o2) -> {
                if (o1.doc == o2.doc) {
                    return o1.shardIndex - o2.shardIndex;
                }
                return o1.doc - o2.doc;
            });
            try {
                for (PerSegmentCollects perSegDocs : this.entries) {
                    perSegDocs.replayRelatedMatches(allDocs);
                }
            }
            catch (IOException e) {
                throw new ElasticsearchException("IOException collecting best scoring results", (Throwable)e, new Object[0]);
            }
        }
        finally {
            this.circuitBreakerConsumer.accept(-12L * (long)this.shardSize);
        }
        this.deferred.postCollection();
    }

    public int getDocCount(long parentBucket) {
        if (this.perBucketSamples.size() <= parentBucket) {
            return 0;
        }
        PerParentBucketSamples sampler = this.perBucketSamples.get((int)parentBucket);
        if (sampler == null) {
            return 0;
        }
        return sampler.getDocCount();
    }

    public void close() throws ElasticsearchException {
        Releasables.close(this.perBucketSamples);
    }

    class PerSegmentCollects
    extends Scorable {
        private final AggregationExecutionContext aggCtx;
        int maxDocId = Integer.MIN_VALUE;
        private float currentScore;
        private Scorable currentScorer;

        PerSegmentCollects(AggregationExecutionContext aggCtx) throws IOException {
            this.aggCtx = aggCtx;
            int i = 0;
            while ((long)i < BestDocsDeferringCollector.this.perBucketSamples.size()) {
                PerParentBucketSamples perBucketSample = BestDocsDeferringCollector.this.perBucketSamples.get(i);
                if (perBucketSample != null) {
                    perBucketSample.changeSegment(aggCtx);
                }
                ++i;
            }
        }

        public void setScorer(Scorable scorer) throws IOException {
            this.currentScorer = scorer;
            int i = 0;
            while ((long)i < BestDocsDeferringCollector.this.perBucketSamples.size()) {
                PerParentBucketSamples perBucketSample = BestDocsDeferringCollector.this.perBucketSamples.get(i);
                if (perBucketSample != null) {
                    perBucketSample.setScorer(scorer);
                }
                ++i;
            }
        }

        public void replayRelatedMatches(List<ScoreDoc> sd) throws IOException {
            try {
                LeafBucketCollector leafCollector = BestDocsDeferringCollector.this.deferred.getLeafCollector(this.aggCtx);
                leafCollector.setScorer(this);
                this.currentScore = 0.0f;
                if (this.maxDocId < 0) {
                    return;
                }
                for (ScoreDoc scoreDoc : sd) {
                    int rebased = scoreDoc.doc - this.aggCtx.getLeafReaderContext().docBase;
                    if (rebased < 0 || rebased > this.maxDocId) continue;
                    this.currentScore = scoreDoc.score;
                    leafCollector.collect(rebased, scoreDoc.shardIndex);
                }
            }
            catch (CollectionTerminatedException collectionTerminatedException) {
                // empty catch block
            }
        }

        public float score() throws IOException {
            return this.currentScore;
        }

        public void collect(int docId, long parentBucket) throws IOException {
            BestDocsDeferringCollector.this.perBucketSamples = BestDocsDeferringCollector.this.bigArrays.grow(BestDocsDeferringCollector.this.perBucketSamples, parentBucket + 1L);
            PerParentBucketSamples sampler = BestDocsDeferringCollector.this.perBucketSamples.get((int)parentBucket);
            if (sampler == null) {
                sampler = new PerParentBucketSamples(BestDocsDeferringCollector.this, parentBucket, this.currentScorer, this.aggCtx);
                BestDocsDeferringCollector.this.perBucketSamples.set((int)parentBucket, sampler);
            }
            sampler.collect(docId);
            this.maxDocId = Math.max(this.maxDocId, docId);
        }
    }

    class PerParentBucketSamples {
        private LeafCollector currentLeafCollector;
        private TopDocsCollector<? extends ScoreDoc> tdc;
        private long parentBucket;
        private int matchedDocs;

        PerParentBucketSamples(BestDocsDeferringCollector this$0, long parentBucket, Scorable scorer, AggregationExecutionContext aggCtx) {
            try {
                this.parentBucket = parentBucket;
                this$0.circuitBreakerConsumer.accept((long)this$0.shardSize * this$0.getPriorityQueueSlotSize());
                this.tdc = this$0.createTopDocsCollector(this$0.shardSize);
                this.currentLeafCollector = this.tdc.getLeafCollector(aggCtx.getLeafReaderContext());
                this.setScorer(scorer);
            }
            catch (IOException e) {
                throw new ElasticsearchException("IO error creating collector", (Throwable)e, new Object[0]);
            }
        }

        public void getMatches(List<ScoreDoc> allDocs) {
            TopDocs topDocs = this.tdc.topDocs();
            ScoreDoc[] sd = topDocs.scoreDocs;
            this.matchedDocs = sd.length;
            for (ScoreDoc scoreDoc : sd) {
                scoreDoc.shardIndex = (int)this.parentBucket;
            }
            allDocs.addAll(Arrays.asList(sd));
        }

        public void collect(int doc) throws IOException {
            this.currentLeafCollector.collect(doc);
        }

        public void setScorer(Scorable scorer) throws IOException {
            this.currentLeafCollector.setScorer(scorer);
        }

        public void changeSegment(AggregationExecutionContext aggCtx) throws IOException {
            this.currentLeafCollector = this.tdc.getLeafCollector(aggCtx.getLeafReaderContext());
        }

        public int getDocCount() {
            return this.matchedDocs;
        }
    }
}

