/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.global;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.search.aggregations.AggregationExecutionException;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.CardinalityUpperBound;
import org.elasticsearch.search.aggregations.bucket.global.GlobalAggregator;
import org.elasticsearch.search.aggregations.support.AggregationContext;

public class GlobalAggregatorFactory
extends AggregatorFactory {
    public GlobalAggregatorFactory(String name, AggregationContext context, AggregatorFactory parent, AggregatorFactories.Builder subFactories, Map<String, Object> metadata) throws IOException {
        super(name, context, parent, subFactories, metadata);
        if (subFactories.isInSortOrderExecutionRequired()) {
            throw new IllegalArgumentException("Time series aggregations cannot be used inside global aggregation.");
        }
    }

    @Override
    public Aggregator createInternal(Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        if (parent != null) {
            throw new IllegalArgumentException("Aggregation [" + parent.name() + "] cannot have a global sub-aggregation [" + this.name + "]. Global aggregations can only be defined as top level aggregations");
        }
        if (cardinality != CardinalityUpperBound.ONE) {
            throw new AggregationExecutionException("Aggregation [" + this.name() + "] must have cardinality 1 but was [" + String.valueOf(cardinality) + "]");
        }
        return new GlobalAggregator(this.name, this.factories, this.context, metadata);
    }
}

