/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.index.stats.IndexingPressureStats;

public class IndexingPressure {
    public static final Setting<ByteSizeValue> MAX_INDEXING_BYTES = Setting.memorySizeSetting("indexing_pressure.memory.limit", "10%", Setting.Property.NodeScope);
    public static final Setting<ByteSizeValue> SPLIT_BULK_THRESHOLD = Setting.memorySizeSetting("indexing_pressure.memory.split_bulk_threshold", "8.5%", Setting.Property.NodeScope);
    public static final Setting<ByteSizeValue> MAX_COORDINATING_BYTES = Setting.memorySizeSetting("indexing_pressure.memory.coordinating.limit", MAX_INDEXING_BYTES, Setting.Property.NodeScope);
    public static final Setting<ByteSizeValue> MAX_PRIMARY_BYTES = Setting.memorySizeSetting("indexing_pressure.memory.primary.limit", MAX_INDEXING_BYTES, Setting.Property.NodeScope);
    public static final Setting<ByteSizeValue> MAX_REPLICA_BYTES = Setting.memorySizeSetting("indexing_pressure.memory.replica.limit", s -> ByteSizeValue.ofBytes((long)((double)MAX_PRIMARY_BYTES.get((Settings)s).getBytes() * 1.5)).getStringRep(), Setting.Property.NodeScope);
    public static final Setting<ByteSizeValue> SPLIT_BULK_HIGH_WATERMARK = Setting.memorySizeSetting("indexing_pressure.memory.split_bulk.watermark.high", "7.5%", Setting.Property.NodeScope);
    public static final Setting<ByteSizeValue> SPLIT_BULK_HIGH_WATERMARK_SIZE = Setting.byteSizeSetting("indexing_pressure.memory.split_bulk.watermark.high.bulk_size", ByteSizeValue.ofMb(1L), Setting.Property.NodeScope);
    public static final Setting<ByteSizeValue> SPLIT_BULK_LOW_WATERMARK = Setting.memorySizeSetting("indexing_pressure.memory.split_bulk.watermark.low", "5.0%", Setting.Property.NodeScope);
    public static final Setting<ByteSizeValue> SPLIT_BULK_LOW_WATERMARK_SIZE = Setting.byteSizeSetting("indexing_pressure.memory.split_bulk.watermark.low.bulk_size", ByteSizeValue.ofMb(4L), Setting.Property.NodeScope);
    private static final Logger logger = LogManager.getLogger(IndexingPressure.class);
    private final AtomicLong currentCombinedCoordinatingAndPrimaryBytes = new AtomicLong(0L);
    private final AtomicLong currentCoordinatingBytes = new AtomicLong(0L);
    private final AtomicLong currentPrimaryBytes = new AtomicLong(0L);
    private final AtomicLong currentReplicaBytes = new AtomicLong(0L);
    private final AtomicLong currentCoordinatingOps = new AtomicLong(0L);
    private final AtomicLong currentPrimaryOps = new AtomicLong(0L);
    private final AtomicLong currentReplicaOps = new AtomicLong(0L);
    private final AtomicLong totalCombinedCoordinatingAndPrimaryBytes = new AtomicLong(0L);
    private final AtomicLong totalCoordinatingBytes = new AtomicLong(0L);
    private final AtomicLong totalPrimaryBytes = new AtomicLong(0L);
    private final AtomicLong totalReplicaBytes = new AtomicLong(0L);
    private final AtomicLong totalCoordinatingOps = new AtomicLong(0L);
    private final AtomicLong totalCoordinatingRequests = new AtomicLong(0L);
    private final AtomicLong totalPrimaryOps = new AtomicLong(0L);
    private final AtomicLong totalReplicaOps = new AtomicLong(0L);
    private final AtomicLong coordinatingRejections = new AtomicLong(0L);
    private final AtomicLong primaryRejections = new AtomicLong(0L);
    private final AtomicLong replicaRejections = new AtomicLong(0L);
    private final AtomicLong primaryDocumentRejections = new AtomicLong(0L);
    private final AtomicLong lowWaterMarkSplits = new AtomicLong(0L);
    private final AtomicLong highWaterMarkSplits = new AtomicLong(0L);
    private final long lowWatermark;
    private final long lowWatermarkSize;
    private final long highWatermark;
    private final long highWatermarkSize;
    private final long coordinatingLimit;
    private final long primaryLimit;
    private final long replicaLimit;

    public IndexingPressure(Settings settings) {
        this.lowWatermark = SPLIT_BULK_LOW_WATERMARK.get(settings).getBytes();
        this.lowWatermarkSize = SPLIT_BULK_LOW_WATERMARK_SIZE.get(settings).getBytes();
        this.highWatermark = SPLIT_BULK_HIGH_WATERMARK.get(settings).getBytes();
        this.highWatermarkSize = SPLIT_BULK_HIGH_WATERMARK_SIZE.get(settings).getBytes();
        this.coordinatingLimit = MAX_COORDINATING_BYTES.get(settings).getBytes();
        this.primaryLimit = MAX_PRIMARY_BYTES.get(settings).getBytes();
        this.replicaLimit = MAX_REPLICA_BYTES.get(settings).getBytes();
    }

    private static Releasable wrapReleasable(Releasable releasable) {
        AtomicBoolean called = new AtomicBoolean();
        return () -> {
            if (called.compareAndSet(false, true)) {
                releasable.close();
            } else {
                logger.error("IndexingPressure memory is adjusted twice", (Throwable)new IllegalStateException("Releasable is called twice"));
                assert (false) : "IndexingPressure is adjusted twice";
            }
        };
    }

    public Releasable markCoordinatingOperationStarted(int operations, long bytes, boolean forceExecution) {
        long combinedBytes = this.currentCombinedCoordinatingAndPrimaryBytes.addAndGet(bytes);
        long replicaWriteBytes = this.currentReplicaBytes.get();
        long totalBytes = combinedBytes + replicaWriteBytes;
        if (!forceExecution && totalBytes > this.coordinatingLimit) {
            long bytesWithoutOperation = combinedBytes - bytes;
            long totalBytesWithoutOperation = totalBytes - bytes;
            this.currentCombinedCoordinatingAndPrimaryBytes.getAndAdd(-bytes);
            this.coordinatingRejections.getAndIncrement();
            throw new EsRejectedExecutionException("rejected execution of coordinating operation [coordinating_and_primary_bytes=" + bytesWithoutOperation + ", replica_bytes=" + replicaWriteBytes + ", all_bytes=" + totalBytesWithoutOperation + ", coordinating_operation_bytes=" + bytes + ", max_coordinating_bytes=" + this.coordinatingLimit + "]", false);
        }
        logger.trace(() -> Strings.format("adding [%d] coordinating operations and [%d] bytes", operations, bytes));
        this.currentCoordinatingBytes.getAndAdd(bytes);
        this.currentCoordinatingOps.getAndAdd(operations);
        this.totalCombinedCoordinatingAndPrimaryBytes.getAndAdd(bytes);
        this.totalCoordinatingBytes.getAndAdd(bytes);
        this.totalCoordinatingOps.getAndAdd(operations);
        this.totalCoordinatingRequests.getAndIncrement();
        return IndexingPressure.wrapReleasable(() -> {
            logger.trace(() -> Strings.format("removing [%d] coordinating operations and [%d] bytes", operations, bytes));
            this.currentCombinedCoordinatingAndPrimaryBytes.getAndAdd(-bytes);
            this.currentCoordinatingBytes.getAndAdd(-bytes);
            this.currentCoordinatingOps.getAndAdd(-operations);
        });
    }

    public Releasable markPrimaryOperationLocalToCoordinatingNodeStarted(int operations, long bytes) {
        this.currentPrimaryBytes.getAndAdd(bytes);
        this.currentPrimaryOps.getAndAdd(operations);
        this.totalPrimaryBytes.getAndAdd(bytes);
        this.totalPrimaryOps.getAndAdd(operations);
        return IndexingPressure.wrapReleasable(() -> {
            this.currentPrimaryBytes.getAndAdd(-bytes);
            this.currentPrimaryOps.getAndAdd(-operations);
        });
    }

    public Releasable markPrimaryOperationStarted(int operations, long bytes, boolean forceExecution) {
        long combinedBytes = this.currentCombinedCoordinatingAndPrimaryBytes.addAndGet(bytes);
        long replicaWriteBytes = this.currentReplicaBytes.get();
        long totalBytes = combinedBytes + replicaWriteBytes;
        if (!forceExecution && totalBytes > this.primaryLimit) {
            long bytesWithoutOperation = combinedBytes - bytes;
            long totalBytesWithoutOperation = totalBytes - bytes;
            this.currentCombinedCoordinatingAndPrimaryBytes.getAndAdd(-bytes);
            this.primaryRejections.getAndIncrement();
            this.primaryDocumentRejections.addAndGet(operations);
            throw new EsRejectedExecutionException("rejected execution of primary operation [coordinating_and_primary_bytes=" + bytesWithoutOperation + ", replica_bytes=" + replicaWriteBytes + ", all_bytes=" + totalBytesWithoutOperation + ", primary_operation_bytes=" + bytes + ", max_primary_bytes=" + this.primaryLimit + "]", false);
        }
        logger.trace(() -> Strings.format("adding [%d] primary operations and [%d] bytes", operations, bytes));
        this.currentPrimaryBytes.getAndAdd(bytes);
        this.currentPrimaryOps.getAndAdd(operations);
        this.totalCombinedCoordinatingAndPrimaryBytes.getAndAdd(bytes);
        this.totalPrimaryBytes.getAndAdd(bytes);
        this.totalPrimaryOps.getAndAdd(operations);
        return IndexingPressure.wrapReleasable(() -> {
            logger.trace(() -> Strings.format("removing [%d] primary operations and [%d] bytes", operations, bytes));
            this.currentCombinedCoordinatingAndPrimaryBytes.getAndAdd(-bytes);
            this.currentPrimaryBytes.getAndAdd(-bytes);
            this.currentPrimaryOps.getAndAdd(-operations);
        });
    }

    public Releasable markReplicaOperationStarted(int operations, long bytes, boolean forceExecution) {
        long replicaWriteBytes = this.currentReplicaBytes.addAndGet(bytes);
        if (!forceExecution && replicaWriteBytes > this.replicaLimit) {
            long replicaBytesWithoutOperation = replicaWriteBytes - bytes;
            this.currentReplicaBytes.getAndAdd(-bytes);
            this.replicaRejections.getAndIncrement();
            throw new EsRejectedExecutionException("rejected execution of replica operation [replica_bytes=" + replicaBytesWithoutOperation + ", replica_operation_bytes=" + bytes + ", max_replica_bytes=" + this.replicaLimit + "]", false);
        }
        this.currentReplicaOps.getAndAdd(operations);
        this.totalReplicaBytes.getAndAdd(bytes);
        this.totalReplicaOps.getAndAdd(operations);
        return IndexingPressure.wrapReleasable(() -> {
            this.currentReplicaBytes.getAndAdd(-bytes);
            this.currentReplicaOps.getAndAdd(-operations);
        });
    }

    public boolean shouldSplitBulk(long size) {
        long currentUsage = this.currentCombinedCoordinatingAndPrimaryBytes.get() + this.currentReplicaBytes.get();
        if (currentUsage >= this.highWatermark && size >= this.highWatermarkSize) {
            this.highWaterMarkSplits.getAndIncrement();
            logger.trace(() -> Strings.format("Split bulk due to high watermark: current bytes [%d] and size [%d]", currentUsage, size));
            return true;
        }
        if (currentUsage >= this.lowWatermark && size >= this.lowWatermarkSize) {
            this.lowWaterMarkSplits.getAndIncrement();
            logger.trace(() -> Strings.format("Split bulk due to low watermark: current bytes [%d] and size [%d]", currentUsage, size));
            return true;
        }
        return false;
    }

    public IndexingPressureStats stats() {
        return new IndexingPressureStats(this.totalCombinedCoordinatingAndPrimaryBytes.get(), this.totalCoordinatingBytes.get(), this.totalPrimaryBytes.get(), this.totalReplicaBytes.get(), this.currentCombinedCoordinatingAndPrimaryBytes.get(), this.currentCoordinatingBytes.get(), this.currentPrimaryBytes.get(), this.currentReplicaBytes.get(), this.coordinatingRejections.get(), this.primaryRejections.get(), this.replicaRejections.get(), this.coordinatingLimit, this.totalCoordinatingOps.get(), this.totalPrimaryOps.get(), this.totalReplicaOps.get(), this.currentCoordinatingOps.get(), this.currentPrimaryOps.get(), this.currentReplicaOps.get(), this.primaryDocumentRejections.get(), this.totalCoordinatingRequests.get(), this.lowWaterMarkSplits.get(), this.highWaterMarkSplits.get());
    }
}

