/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gateway;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.nodes.BaseNodeResponse;
import org.elasticsearch.action.support.nodes.BaseNodesResponse;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.RerouteService;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.AllocateUnassignedDecision;
import org.elasticsearch.cluster.routing.allocation.ExistingShardsAllocator;
import org.elasticsearch.cluster.routing.allocation.FailedShard;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.core.Strings;
import org.elasticsearch.gateway.AsyncShardFetch;
import org.elasticsearch.gateway.PrimaryShardAllocator;
import org.elasticsearch.gateway.ReplicaShardAllocator;
import org.elasticsearch.gateway.TransportNodesListGatewayStartedShards;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.store.TransportNodesListShardStoreMetadata;
import org.elasticsearch.injection.guice.Inject;

public class GatewayAllocator
implements ExistingShardsAllocator {
    public static final String ALLOCATOR_NAME = "gateway_allocator";
    private static final Logger logger = LogManager.getLogger(GatewayAllocator.class);
    private final RerouteService rerouteService;
    private final PrimaryShardAllocator primaryShardAllocator;
    private final ReplicaShardAllocator replicaShardAllocator;
    private final ConcurrentMap<ShardId, AsyncShardFetch<TransportNodesListGatewayStartedShards.NodeGatewayStartedShards>> asyncFetchStarted = ConcurrentCollections.newConcurrentMap();
    private final ConcurrentMap<ShardId, AsyncShardFetch<TransportNodesListShardStoreMetadata.NodeStoreFilesMetadata>> asyncFetchStore = ConcurrentCollections.newConcurrentMap();
    private Set<String> lastSeenEphemeralIds = Collections.emptySet();

    @Inject
    public GatewayAllocator(RerouteService rerouteService, NodeClient client) {
        this.rerouteService = rerouteService;
        this.primaryShardAllocator = new InternalPrimaryShardAllocator(client);
        this.replicaShardAllocator = new InternalReplicaShardAllocator(client);
    }

    @Override
    public void cleanCaches() {
        Releasables.close(this.asyncFetchStarted.values());
        this.asyncFetchStarted.clear();
        Releasables.close(this.asyncFetchStore.values());
        this.asyncFetchStore.clear();
    }

    protected GatewayAllocator() {
        this.rerouteService = null;
        this.primaryShardAllocator = null;
        this.replicaShardAllocator = null;
    }

    @Override
    public int getNumberOfInFlightFetches() {
        int count = 0;
        for (AsyncShardFetch fetch : this.asyncFetchStarted.values()) {
            count += fetch.getNumberOfInFlightFetches();
        }
        for (AsyncShardFetch fetch : this.asyncFetchStore.values()) {
            count += fetch.getNumberOfInFlightFetches();
        }
        return count;
    }

    @Override
    public void applyStartedShards(List<ShardRouting> startedShards, RoutingAllocation allocation) {
        for (ShardRouting startedShard : startedShards) {
            Releasables.close((Releasable)((Releasable)this.asyncFetchStarted.remove(startedShard.shardId())));
            Releasables.close((Releasable)((Releasable)this.asyncFetchStore.remove(startedShard.shardId())));
        }
    }

    @Override
    public void applyFailedShards(List<FailedShard> failedShards, RoutingAllocation allocation) {
        for (FailedShard failedShard : failedShards) {
            Releasables.close((Releasable)((Releasable)this.asyncFetchStarted.remove(failedShard.routingEntry().shardId())));
            Releasables.close((Releasable)((Releasable)this.asyncFetchStore.remove(failedShard.routingEntry().shardId())));
        }
    }

    @Override
    public void beforeAllocation(RoutingAllocation allocation) {
        assert (this.primaryShardAllocator != null);
        assert (this.replicaShardAllocator != null);
        this.ensureAsyncFetchStorePrimaryRecency(allocation);
    }

    @Override
    public void afterPrimariesBeforeReplicas(RoutingAllocation allocation, Predicate<ShardRouting> isRelevantShardPredicate) {
        assert (this.replicaShardAllocator != null);
        if (allocation.routingNodes().hasInactiveReplicas()) {
            this.replicaShardAllocator.processExistingRecoveries(allocation, isRelevantShardPredicate);
        }
    }

    @Override
    public void allocateUnassigned(ShardRouting shardRouting, RoutingAllocation allocation, ExistingShardsAllocator.UnassignedAllocationHandler unassignedAllocationHandler) {
        assert (this.primaryShardAllocator != null);
        assert (this.replicaShardAllocator != null);
        GatewayAllocator.innerAllocatedUnassigned(allocation, this.primaryShardAllocator, this.replicaShardAllocator, shardRouting, unassignedAllocationHandler);
    }

    protected static void innerAllocatedUnassigned(RoutingAllocation allocation, PrimaryShardAllocator primaryShardAllocator, ReplicaShardAllocator replicaShardAllocator, ShardRouting shardRouting, ExistingShardsAllocator.UnassignedAllocationHandler unassignedAllocationHandler) {
        assert (shardRouting.unassigned());
        if (shardRouting.primary()) {
            primaryShardAllocator.allocateUnassigned(shardRouting, allocation, unassignedAllocationHandler);
        } else {
            replicaShardAllocator.allocateUnassigned(shardRouting, allocation, unassignedAllocationHandler);
        }
    }

    @Override
    public AllocateUnassignedDecision explainUnassignedShardAllocation(ShardRouting unassignedShard, RoutingAllocation routingAllocation) {
        assert (unassignedShard.unassigned());
        assert (routingAllocation.debugDecision());
        if (unassignedShard.primary()) {
            assert (this.primaryShardAllocator != null);
            return this.primaryShardAllocator.makeAllocationDecision(unassignedShard, routingAllocation, logger);
        }
        assert (this.replicaShardAllocator != null);
        return this.replicaShardAllocator.makeAllocationDecision(unassignedShard, routingAllocation, logger);
    }

    private void ensureAsyncFetchStorePrimaryRecency(RoutingAllocation allocation) {
        DiscoveryNodes nodes = allocation.nodes();
        if (this.hasNewNodes(nodes)) {
            Set newEphemeralIds = nodes.getDataNodes().values().stream().map(DiscoveryNode::getEphemeralId).collect(Collectors.toSet());
            logger.trace(() -> Strings.format((String)"new nodes %s found, clearing primary async-fetch-store cache", (Object[])new Object[]{Sets.difference(newEphemeralIds, this.lastSeenEphemeralIds)}));
            this.asyncFetchStore.values().forEach(fetch -> GatewayAllocator.clearCacheForPrimary(fetch, allocation));
            this.lastSeenEphemeralIds = newEphemeralIds;
        }
    }

    private static void clearCacheForPrimary(AsyncShardFetch<TransportNodesListShardStoreMetadata.NodeStoreFilesMetadata> fetch, RoutingAllocation allocation) {
        ShardRouting primary = allocation.routingNodes().activePrimary(fetch.shardId);
        if (primary != null) {
            fetch.clearCacheForNode(primary.currentNodeId());
        }
    }

    private boolean hasNewNodes(DiscoveryNodes nodes) {
        for (Map.Entry<String, DiscoveryNode> node : nodes.getDataNodes().entrySet()) {
            if (this.lastSeenEphemeralIds.contains(node.getValue().getEphemeralId())) continue;
            return true;
        }
        return false;
    }

    class InternalPrimaryShardAllocator
    extends PrimaryShardAllocator {
        private final NodeClient client;

        InternalPrimaryShardAllocator(NodeClient client) {
            this.client = client;
        }

        @Override
        protected AsyncShardFetch.FetchResult<TransportNodesListGatewayStartedShards.NodeGatewayStartedShards> fetchData(ShardRouting shard, RoutingAllocation allocation) {
            AsyncShardFetch fetch = GatewayAllocator.this.asyncFetchStarted.computeIfAbsent(shard.shardId(), shardId -> new InternalAsyncFetch<TransportNodesListGatewayStartedShards.NodeGatewayStartedShards>(this.logger, "shard_started", shardId, IndexMetadata.INDEX_DATA_PATH_SETTING.get(allocation.metadata().index(shard.index()).getSettings()), allocation.routingNodes().size()){

                @Override
                protected void list(ShardId shardId, String customDataPath, DiscoveryNode[] nodes, ActionListener<BaseNodesResponse<TransportNodesListGatewayStartedShards.NodeGatewayStartedShards>> listener) {
                    InternalPrimaryShardAllocator.this.client.executeLocally(TransportNodesListGatewayStartedShards.TYPE, new TransportNodesListGatewayStartedShards.Request(shardId, customDataPath, nodes), listener.safeMap(r -> r));
                }
            });
            AsyncShardFetch.FetchResult<TransportNodesListGatewayStartedShards.NodeGatewayStartedShards> shardState = fetch.fetchData(allocation.nodes(), allocation.getIgnoreNodes(shard.shardId()));
            if (shardState.hasData()) {
                shardState.processAllocation(allocation);
            }
            return shardState;
        }
    }

    class InternalReplicaShardAllocator
    extends ReplicaShardAllocator {
        private final NodeClient client;

        InternalReplicaShardAllocator(NodeClient client) {
            this.client = client;
        }

        @Override
        protected AsyncShardFetch.FetchResult<TransportNodesListShardStoreMetadata.NodeStoreFilesMetadata> fetchData(ShardRouting shard, RoutingAllocation allocation) {
            AsyncShardFetch fetch = GatewayAllocator.this.asyncFetchStore.computeIfAbsent(shard.shardId(), shardId -> new InternalAsyncFetch<TransportNodesListShardStoreMetadata.NodeStoreFilesMetadata>(this.logger, "shard_store", shard.shardId(), IndexMetadata.INDEX_DATA_PATH_SETTING.get(allocation.metadata().index(shard.index()).getSettings()), allocation.routingNodes().size()){

                @Override
                protected void list(ShardId shardId, String customDataPath, DiscoveryNode[] nodes, ActionListener<BaseNodesResponse<TransportNodesListShardStoreMetadata.NodeStoreFilesMetadata>> listener) {
                    InternalReplicaShardAllocator.this.client.executeLocally(TransportNodesListShardStoreMetadata.TYPE, new TransportNodesListShardStoreMetadata.Request(shardId, customDataPath, nodes), listener.safeMap(r -> r));
                }
            });
            AsyncShardFetch.FetchResult<TransportNodesListShardStoreMetadata.NodeStoreFilesMetadata> shardStores = fetch.fetchData(allocation.nodes(), allocation.getIgnoreNodes(shard.shardId()));
            if (shardStores.hasData()) {
                shardStores.processAllocation(allocation);
            }
            return shardStores;
        }

        @Override
        protected boolean hasInitiatedFetching(ShardRouting shard) {
            return GatewayAllocator.this.asyncFetchStore.get(shard.shardId()) != null;
        }
    }

    abstract class InternalAsyncFetch<T extends BaseNodeResponse>
    extends AsyncShardFetch<T> {
        InternalAsyncFetch(Logger logger, String type, ShardId shardId, String customDataPath, int expectedSize) {
            super(logger, type, shardId, customDataPath, expectedSize);
        }

        @Override
        protected void reroute(ShardId shardId, String reason) {
            this.logger.trace("{} scheduling reroute for {}", (Object)shardId, (Object)reason);
            assert (GatewayAllocator.this.rerouteService != null);
            GatewayAllocator.this.rerouteService.reroute("async_shard_fetch", Priority.HIGH, ActionListener.wrap(r -> this.logger.trace("{} scheduled reroute completed for {}", (Object)shardId, (Object)reason), e -> this.logger.debug(() -> Strings.format((String)"%s scheduled reroute failed for %s", (Object[])new Object[]{shardId, reason}), (Throwable)e)));
        }
    }
}

