/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util.concurrent;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.ReferenceDocs;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.WrappedRunnable;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.http.HttpTransportSettings;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.telemetry.tracing.TraceContext;

public final class ThreadContext
implements Writeable,
TraceContext {
    public static final String PREFIX = "request.headers";
    public static final Setting<Settings> DEFAULT_HEADERS_SETTING = Setting.groupSetting("request.headers.", Setting.Property.NodeScope);
    public static final String ACTION_ORIGIN_TRANSIENT_NAME = "action.origin";
    private static final Logger logger = LogManager.getLogger(ThreadContext.class);
    private static final ThreadContextStruct DEFAULT_CONTEXT = new ThreadContextStruct();
    private final Map<String, String> defaultHeader;
    private final ThreadLocal<ThreadContextStruct> threadLocal;
    private final int maxWarningHeaderCount;
    private final long maxWarningHeaderSize;

    public ThreadContext(Settings settings) {
        this.defaultHeader = ThreadContext.buildDefaultHeaders(settings);
        this.threadLocal = ThreadLocal.withInitial(() -> DEFAULT_CONTEXT);
        this.maxWarningHeaderCount = HttpTransportSettings.SETTING_HTTP_MAX_WARNING_HEADER_COUNT.get(settings);
        this.maxWarningHeaderSize = HttpTransportSettings.SETTING_HTTP_MAX_WARNING_HEADER_SIZE.get(settings).getBytes();
    }

    public StoredContext stashContext() {
        return this.stashContextPreservingRequestHeaders(Collections.emptySet());
    }

    public StoredContext stashContextPreservingRequestHeaders(Set<String> requestHeaders) {
        ThreadContextStruct context = this.threadLocal.get();
        Set<String> requestHeadersToCopy = ThreadContext.getRequestHeadersToCopy(requestHeaders);
        boolean hasHeadersToCopy = false;
        if (!context.requestHeaders.isEmpty()) {
            for (String header : requestHeadersToCopy) {
                if (!context.requestHeaders.containsKey(header)) continue;
                hasHeadersToCopy = true;
                break;
            }
        }
        boolean hasTransientHeadersToCopy = context.transientHeaders.containsKey("apm.local.context");
        ThreadContextStruct threadContextStruct = DEFAULT_CONTEXT;
        if (hasHeadersToCopy) {
            Map<String, String> copiedHeaders = ThreadContext.getHeadersPresentInContext(context, requestHeadersToCopy);
            threadContextStruct = DEFAULT_CONTEXT.putHeaders(copiedHeaders);
        }
        if (hasTransientHeadersToCopy) {
            threadContextStruct = threadContextStruct.putTransient("apm.local.context", context.transientHeaders.get("apm.local.context"));
        }
        this.threadLocal.set(threadContextStruct);
        return this.storedOriginalContext(context);
    }

    public StoredContext stashContextPreservingRequestHeaders(String ... requestHeaders) {
        return this.stashContextPreservingRequestHeaders(Set.of(requestHeaders));
    }

    public StoredContext newEmptyContext() {
        ThreadContextStruct callingContext = this.threadLocal.get();
        this.threadLocal.set(DEFAULT_CONTEXT);
        return this.storedOriginalContext(callingContext);
    }

    public StoredContext newEmptySystemContext() {
        ThreadContextStruct callingContext = this.threadLocal.get();
        this.threadLocal.set(DEFAULT_CONTEXT.setSystemContext());
        return this.storedOriginalContext(callingContext);
    }

    public StoredContext newTraceContext() {
        Object previousTraceContext;
        String previousTraceState;
        ThreadContextStruct originalContext = this.threadLocal.get();
        HashMap<String, String> newRequestHeaders = new HashMap<String, String>(originalContext.requestHeaders);
        HashMap<String, Object> newTransientHeaders = new HashMap<String, Object>(originalContext.transientHeaders);
        String previousTraceParent = (String)newRequestHeaders.remove("traceparent");
        if (previousTraceParent != null) {
            newTransientHeaders.put("parent_traceparent", previousTraceParent);
        }
        if ((previousTraceState = (String)newRequestHeaders.remove("tracestate")) != null) {
            newTransientHeaders.put("parent_tracestate", previousTraceState);
        }
        if ((previousTraceContext = newTransientHeaders.remove("apm.local.context")) != null) {
            newTransientHeaders.put("parent_apm.local.context", previousTraceContext);
        }
        ThreadContextStruct newContext = new ThreadContextStruct(newRequestHeaders, originalContext.responseHeaders, newTransientHeaders, originalContext.isSystemContext, originalContext.warningHeadersSize);
        this.threadLocal.set(newContext);
        return () -> {
            ThreadContextStruct found = this.threadLocal.get();
            if (found != newContext) {
                this.threadLocal.set(originalContext.putResponseHeaders(found.responseHeaders));
            } else {
                this.threadLocal.set(originalContext);
            }
        };
    }

    public boolean hasTraceContext() {
        ThreadContextStruct context = this.threadLocal.get();
        return context.requestHeaders.containsKey("traceparent") || context.requestHeaders.containsKey("tracestate") || context.transientHeaders.containsKey("apm.local.context");
    }

    public StoredContext clearTraceContext() {
        ThreadContextStruct context = this.threadLocal.get();
        HashMap<String, String> newRequestHeaders = new HashMap<String, String>(context.requestHeaders);
        HashMap<String, Object> newTransientHeaders = new HashMap<String, Object>(context.transientHeaders);
        newRequestHeaders.remove("traceparent");
        newRequestHeaders.remove("tracestate");
        newTransientHeaders.remove("parent_traceparent");
        newTransientHeaders.remove("parent_tracestate");
        newTransientHeaders.remove("apm.local.context");
        newTransientHeaders.remove("parent_apm.local.context");
        this.threadLocal.set(new ThreadContextStruct(newRequestHeaders, context.responseHeaders, newTransientHeaders, context.isSystemContext, context.warningHeadersSize));
        return this.storedOriginalContext(context);
    }

    private StoredContext storedOriginalContext(ThreadContextStruct originalContext) {
        return () -> this.threadLocal.set(originalContext);
    }

    private static Set<String> getRequestHeadersToCopy(Set<String> requestHeaders) {
        if (requestHeaders.isEmpty()) {
            return Task.HEADERS_TO_COPY;
        }
        HashSet<String> allRequestHeadersToCopy = new HashSet<String>(requestHeaders);
        allRequestHeadersToCopy.addAll(Task.HEADERS_TO_COPY);
        return Set.copyOf(allRequestHeadersToCopy);
    }

    private static Map<String, String> getHeadersPresentInContext(ThreadContextStruct context, Set<String> headers) {
        Map<String, String> map = Maps.newMapWithExpectedSize(headers.size());
        for (String header : headers) {
            String value = context.requestHeaders.get(header);
            if (value == null) continue;
            map.put(header, value);
        }
        return map;
    }

    public Writeable captureAsWriteable() {
        ThreadContextStruct context = this.threadLocal.get();
        return out -> context.writeTo(out, this.defaultHeader);
    }

    public StoredContext stashWithOrigin(String origin) {
        StoredContext storedContext = this.stashContext();
        this.putTransient(ACTION_ORIGIN_TRANSIENT_NAME, origin);
        return storedContext;
    }

    public StoredContext stashAndMergeHeaders(Map<String, String> headers) {
        ThreadContextStruct context = this.threadLocal.get();
        HashMap<String, String> newHeader = new HashMap<String, String>(headers);
        newHeader.putAll(context.requestHeaders);
        this.threadLocal.set(DEFAULT_CONTEXT.putHeaders(newHeader));
        return this.storedOriginalContext(context);
    }

    public StoredContext newStoredContextPreservingResponseHeaders() {
        ThreadContextStruct originalContext = this.threadLocal.get();
        return () -> {
            ThreadContextStruct found = this.threadLocal.get();
            if (found != originalContext) {
                this.threadLocal.set(originalContext.putResponseHeaders(found.responseHeaders));
            }
        };
    }

    public StoredContext restoreExistingContext(StoredContext existingContext) {
        ThreadContextStruct originalContext = this.threadLocal.get();
        existingContext.restore();
        return this.storedOriginalContext(originalContext);
    }

    public StoredContext newStoredContext() {
        ThreadContextStruct originalContext = this.threadLocal.get();
        return this.storedOriginalContext(originalContext);
    }

    public StoredContext newStoredContext(Collection<String> transientHeadersToClear, Collection<String> requestHeadersToClear) {
        return this.newStoredContext(false, transientHeadersToClear, requestHeadersToClear);
    }

    public StoredContext newStoredContextPreservingResponseHeaders(Collection<String> transientHeadersToClear, Collection<String> requestHeadersToClear) {
        return this.newStoredContext(true, transientHeadersToClear, requestHeadersToClear);
    }

    private StoredContext newStoredContext(boolean preserveResponseHeaders, Collection<String> transientHeadersToClear, Collection<String> requestHeadersToClear) {
        ThreadContextStruct originalContext = this.threadLocal.get();
        HashMap<String, Object> newTransientHeaders = null;
        for (String string : transientHeadersToClear) {
            if (!originalContext.transientHeaders.containsKey(string)) continue;
            if (newTransientHeaders == null) {
                newTransientHeaders = new HashMap<String, Object>(originalContext.transientHeaders);
            }
            newTransientHeaders.remove(string);
        }
        Map<String, String> newRequestHeaders = null;
        for (String requestHeaderToClear : requestHeadersToClear) {
            if (!originalContext.requestHeaders.containsKey(requestHeaderToClear)) continue;
            if (newRequestHeaders == null) {
                newRequestHeaders = new HashMap<String, String>(originalContext.requestHeaders);
            }
            newRequestHeaders.remove(requestHeaderToClear);
        }
        if (newTransientHeaders != null || newRequestHeaders != null) {
            ThreadContextStruct threadContextStruct = new ThreadContextStruct(newRequestHeaders != null ? newRequestHeaders : originalContext.requestHeaders, originalContext.responseHeaders, newTransientHeaders != null ? newTransientHeaders : originalContext.transientHeaders, originalContext.isSystemContext, originalContext.warningHeadersSize);
            this.threadLocal.set(threadContextStruct);
        }
        ThreadContextStruct threadContextStruct = this.threadLocal.get();
        return () -> {
            if (preserveResponseHeaders && this.threadLocal.get() != newContext) {
                this.threadLocal.set(originalContext.putResponseHeaders(this.threadLocal.get().responseHeaders));
            } else {
                this.threadLocal.set(originalContext);
            }
        };
    }

    public Supplier<StoredContext> newRestorableContext(boolean preserveResponseHeaders) {
        return this.wrapRestorable(preserveResponseHeaders ? this.newStoredContextPreservingResponseHeaders() : this.newStoredContext());
    }

    public Supplier<StoredContext> wrapRestorable(StoredContext storedContext) {
        return () -> {
            StoredContext context = this.newStoredContext();
            storedContext.restore();
            return context;
        };
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.threadLocal.get().writeTo(out, this.defaultHeader);
    }

    public void readHeaders(StreamInput in) throws IOException {
        this.setHeaders(ThreadContext.readHeadersFromStream(in));
    }

    public void setHeaders(Tuple<Map<String, String>, Map<String, Set<String>>> headerTuple) {
        Map requestHeaders = (Map)headerTuple.v1();
        Map responseHeaders = (Map)headerTuple.v2();
        ThreadContextStruct struct = requestHeaders.isEmpty() && responseHeaders.isEmpty() ? ThreadContextStruct.EMPTY : new ThreadContextStruct(requestHeaders, responseHeaders, Collections.emptyMap(), false);
        this.threadLocal.set(struct);
    }

    public static Tuple<Map<String, String>, Map<String, Set<String>>> readHeadersFromStream(StreamInput in) throws IOException {
        Map<String, String> requestHeaders = in.readMap(StreamInput::readString);
        Map<String, Set> responseHeaders = in.readMap(input -> {
            int size = input.readVInt();
            if (size == 0) {
                return Collections.emptySet();
            }
            if (size == 1) {
                return Collections.singleton(input.readString());
            }
            LinkedHashSet<String> values = Sets.newLinkedHashSetWithExpectedSize(size);
            for (int i = 0; i < size; ++i) {
                String value = input.readString();
                boolean added = values.add(value);
                assert (added) : value;
            }
            return values;
        });
        return new Tuple(requestHeaders, responseHeaders);
    }

    @Override
    public String getHeader(String key) {
        String value = this.threadLocal.get().requestHeaders.get(key);
        if (value == null) {
            return this.defaultHeader.get(key);
        }
        return value;
    }

    public String getHeaderOrDefault(String key, String defaultValue) {
        String value = this.getHeader(key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public Map<String, String> getHeaders() {
        HashMap<String, String> map = new HashMap<String, String>(this.defaultHeader);
        map.putAll(this.threadLocal.get().requestHeaders);
        return Collections.unmodifiableMap(map);
    }

    public Map<String, String> getRequestHeadersOnly() {
        return Collections.unmodifiableMap(new HashMap<String, String>(this.threadLocal.get().requestHeaders));
    }

    public Map<String, List<String>> getResponseHeaders() {
        Map<String, Set<String>> responseHeaders = this.threadLocal.get().responseHeaders;
        Map map = Maps.newMapWithExpectedSize(responseHeaders.size());
        for (Map.Entry<String, Set<String>> entry : responseHeaders.entrySet()) {
            map.put(entry.getKey(), List.copyOf((Collection)entry.getValue()));
        }
        return Collections.unmodifiableMap(map);
    }

    public void copyHeaders(Iterable<Map.Entry<String, String>> headers) {
        this.threadLocal.set(this.threadLocal.get().copyHeaders(headers));
    }

    @Override
    public void putHeader(String key, String value) {
        this.threadLocal.set(this.threadLocal.get().putRequest(key, value));
    }

    public void putHeader(Map<String, String> header) {
        this.threadLocal.set(this.threadLocal.get().putHeaders(header));
    }

    public void setErrorTraceTransportHeader(RestRequest r) {
        if (r.paramAsBoolean("error_trace", false)) {
            this.putHeader("error_trace", "true");
        }
    }

    @Override
    public void putTransient(String key, Object value) {
        this.threadLocal.set(this.threadLocal.get().putTransient(key, value));
    }

    @Override
    public <T> T getTransient(String key) {
        return (T)this.threadLocal.get().transientHeaders.get(key);
    }

    public Map<String, Object> getTransientHeaders() {
        return Collections.unmodifiableMap(this.threadLocal.get().transientHeaders);
    }

    public void addResponseHeader(String key, String value) {
        this.addResponseHeader(key, value, v -> v);
    }

    public void addResponseHeader(String key, String value, Function<String, String> uniqueValue) {
        this.threadLocal.set(this.threadLocal.get().putResponse(key, value, uniqueValue, this.maxWarningHeaderCount, this.maxWarningHeaderSize));
    }

    public Runnable preserveContext(Runnable command) {
        return this.doPreserveContext(command, false);
    }

    public Runnable preserveContextWithTracing(Runnable command) {
        return this.doPreserveContext(command, true);
    }

    private Runnable doPreserveContext(Runnable command, boolean preserveContext) {
        if (command instanceof ContextPreservingAbstractRunnable) {
            return command;
        }
        if (command instanceof ContextPreservingRunnable) {
            return command;
        }
        if (command instanceof AbstractRunnable) {
            AbstractRunnable abstractRunnable = (AbstractRunnable)command;
            return new ContextPreservingAbstractRunnable(abstractRunnable, preserveContext);
        }
        return new ContextPreservingRunnable(command);
    }

    public static Runnable unwrap(Runnable command) {
        if (command instanceof WrappedRunnable) {
            return ((WrappedRunnable)command).unwrap();
        }
        return command;
    }

    public boolean isDefaultContext() {
        return this.threadLocal.get() == DEFAULT_CONTEXT;
    }

    public void markAsSystemContext() {
        this.threadLocal.set(this.threadLocal.get().setSystemContext());
    }

    public boolean isSystemContext() {
        return this.threadLocal.get().isSystemContext;
    }

    public void sanitizeHeaders() {
        ThreadContextStruct originalContext = this.threadLocal.get();
        HashMap<String, String> newRequestHeaders = new HashMap<String, String>(originalContext.requestHeaders);
        newRequestHeaders.entrySet().removeIf(entry -> ((String)entry.getKey()).equalsIgnoreCase("authorization") || ((String)entry.getKey()).equalsIgnoreCase("es-secondary-authorization") || ((String)entry.getKey()).equalsIgnoreCase("ES-Client-Authentication"));
        ThreadContextStruct newContext = new ThreadContextStruct(newRequestHeaders, originalContext.responseHeaders, originalContext.transientHeaders, originalContext.isSystemContext, originalContext.warningHeadersSize);
        this.threadLocal.set(newContext);
    }

    public static Map<String, String> buildDefaultHeaders(Settings settings) {
        Settings headers = DEFAULT_HEADERS_SETTING.get(settings);
        if (headers == null) {
            return Map.of();
        }
        HashMap<String, String> defaultHeader = new HashMap<String, String>();
        for (String key : headers.names()) {
            defaultHeader.put(key, headers.get(key));
        }
        return Map.copyOf(defaultHeader);
    }

    @FunctionalInterface
    public static interface StoredContext
    extends AutoCloseable,
    Releasable {
        default public void restore() {
            this.close();
        }
    }

    private static final class ThreadContextStruct {
        private static final ThreadContextStruct EMPTY = new ThreadContextStruct(Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), false);
        private final Map<String, String> requestHeaders;
        private final Map<String, Object> transientHeaders;
        private final Map<String, Set<String>> responseHeaders;
        private final boolean isSystemContext;
        private final long warningHeadersSize;

        private ThreadContextStruct setSystemContext() {
            if (this.isSystemContext) {
                return this;
            }
            return new ThreadContextStruct(this.requestHeaders, this.responseHeaders, this.transientHeaders, true);
        }

        private ThreadContextStruct(Map<String, String> requestHeaders, Map<String, Set<String>> responseHeaders, Map<String, Object> transientHeaders, boolean isSystemContext) {
            this(requestHeaders, responseHeaders, transientHeaders, isSystemContext, 0L);
        }

        private ThreadContextStruct(Map<String, String> requestHeaders, Map<String, Set<String>> responseHeaders, Map<String, Object> transientHeaders, boolean isSystemContext, long warningHeadersSize) {
            this.requestHeaders = requestHeaders;
            this.responseHeaders = responseHeaders;
            this.transientHeaders = transientHeaders;
            this.isSystemContext = isSystemContext;
            this.warningHeadersSize = warningHeadersSize;
        }

        private ThreadContextStruct() {
            this(Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), false);
        }

        private ThreadContextStruct putRequest(String key, String value) {
            HashMap<String, String> newRequestHeaders = new HashMap<String, String>(this.requestHeaders);
            ThreadContextStruct.putSingleHeader(key, value, newRequestHeaders);
            return new ThreadContextStruct(newRequestHeaders, this.responseHeaders, this.transientHeaders, this.isSystemContext);
        }

        private static <T> void putSingleHeader(String key, T value, Map<String, T> newHeaders) {
            if (newHeaders.putIfAbsent(key, value) != null) {
                throw new IllegalArgumentException("value for key [" + key + "] already present");
            }
        }

        private ThreadContextStruct putHeaders(Map<String, String> headers) {
            if (headers.isEmpty()) {
                return this;
            }
            HashMap<String, String> newHeaders = new HashMap<String, String>(this.requestHeaders);
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                ThreadContextStruct.putSingleHeader(entry.getKey(), entry.getValue(), newHeaders);
            }
            return new ThreadContextStruct(newHeaders, this.responseHeaders, this.transientHeaders, this.isSystemContext);
        }

        private ThreadContextStruct putResponseHeaders(Map<String, Set<String>> headers) {
            assert (headers != null);
            if (headers.isEmpty()) {
                return this;
            }
            HashMap<String, Set<String>> newResponseHeaders = new HashMap<String, Set<String>>(this.responseHeaders);
            for (Map.Entry<String, Set<String>> entry : headers.entrySet()) {
                newResponseHeaders.merge(entry.getKey(), entry.getValue(), (existing, added) -> {
                    LinkedHashSet updated = new LinkedHashSet(added);
                    updated.addAll(existing);
                    return Collections.unmodifiableSet(updated);
                });
            }
            return new ThreadContextStruct(this.requestHeaders, newResponseHeaders, this.transientHeaders, this.isSystemContext);
        }

        private void logWarningHeaderThresholdExceeded(long threshold, Setting<?> thresholdSetting) {
            HashMap<String, String> selectedHeaders = new HashMap<String, String>(this.requestHeaders);
            selectedHeaders.keySet().retainAll(List.of("X-Opaque-Id", "X-elastic-product-origin"));
            boolean sizeExceeded = HttpTransportSettings.SETTING_HTTP_MAX_WARNING_HEADER_SIZE.equals(thresholdSetting);
            StringBuilder message = new StringBuilder().append("Dropping a warning header");
            if (!selectedHeaders.isEmpty()) {
                message.append(" for request [").append(selectedHeaders).append("]");
            }
            message.append(", as their total").append(sizeExceeded ? " size" : " count");
            message.append(" reached the maximum allowed of [").append(threshold).append("]").append(sizeExceeded ? " bytes" : "");
            message.append(" set in [").append(thresholdSetting.getKey()).append("]!");
            if (!selectedHeaders.containsKey("X-Opaque-Id")) {
                message.append(" Add X-Opaque-Id headers to identify the source of this warning");
                message.append(", see ").append((Object)ReferenceDocs.X_OPAQUE_ID).append(" for more information.");
            }
            logger.warn((CharSequence)message);
        }

        private ThreadContextStruct putResponse(String key, String value, Function<String, String> uniqueValue, int maxWarningHeaderCount, long maxWarningHeaderSize) {
            Set<String> existingValues;
            assert (value != null);
            long newWarningHeaderSize = this.warningHeadersSize;
            if (key.equals("Warning") && maxWarningHeaderSize != -1L) {
                if (this.warningHeadersSize > maxWarningHeaderSize) {
                    this.logWarningHeaderThresholdExceeded(maxWarningHeaderSize, HttpTransportSettings.SETTING_HTTP_MAX_WARNING_HEADER_SIZE);
                    return this;
                }
                if ((newWarningHeaderSize += (long)("Warning".getBytes(StandardCharsets.UTF_8).length + value.getBytes(StandardCharsets.UTF_8).length)) > maxWarningHeaderSize) {
                    this.logWarningHeaderThresholdExceeded(maxWarningHeaderSize, HttpTransportSettings.SETTING_HTTP_MAX_WARNING_HEADER_SIZE);
                    return new ThreadContextStruct(this.requestHeaders, this.responseHeaders, this.transientHeaders, this.isSystemContext, newWarningHeaderSize);
                }
            }
            if ((existingValues = this.responseHeaders.get(key)) != null && existingValues.contains(uniqueValue.apply(value))) {
                return this;
            }
            HashMap<String, Set<String>> newResponseHeaders = new HashMap<String, Set<String>>(this.responseHeaders);
            if (existingValues != null) {
                LinkedHashSet<String> newValues = new LinkedHashSet<String>(existingValues);
                newValues.add(value);
                newResponseHeaders.put(key, Collections.unmodifiableSet(newValues));
            } else {
                newResponseHeaders.put(key, Collections.singleton(value));
            }
            if (key.equals("Warning") && maxWarningHeaderCount != -1) {
                int warningHeaderCount;
                int n = warningHeaderCount = newResponseHeaders.containsKey("Warning") ? ((Set)newResponseHeaders.get("Warning")).size() : 0;
                if (warningHeaderCount > maxWarningHeaderCount) {
                    this.logWarningHeaderThresholdExceeded(maxWarningHeaderCount, HttpTransportSettings.SETTING_HTTP_MAX_WARNING_HEADER_COUNT);
                    return this;
                }
            }
            return new ThreadContextStruct(this.requestHeaders, newResponseHeaders, this.transientHeaders, this.isSystemContext, newWarningHeaderSize);
        }

        private ThreadContextStruct putTransient(String key, Object value) {
            HashMap<String, Object> newTransient = new HashMap<String, Object>(this.transientHeaders);
            ThreadContextStruct.putSingleHeader(key, value, newTransient);
            return new ThreadContextStruct(this.requestHeaders, this.responseHeaders, newTransient, this.isSystemContext);
        }

        private ThreadContextStruct copyHeaders(Iterable<Map.Entry<String, String>> headers) {
            HashMap<String, String> newHeaders = new HashMap<String, String>();
            for (Map.Entry<String, String> header : headers) {
                newHeaders.put(header.getKey(), header.getValue());
            }
            return this.putHeaders(newHeaders);
        }

        private void writeTo(StreamOutput out, Map<String, String> defaultHeaders) throws IOException {
            Map<String, String> requestHeaders;
            if (defaultHeaders.isEmpty()) {
                requestHeaders = this.requestHeaders;
            } else {
                requestHeaders = new HashMap<String, String>(defaultHeaders);
                requestHeaders.putAll(this.requestHeaders);
            }
            out.writeMap(requestHeaders, StreamOutput::writeString);
            out.writeMap(this.responseHeaders, StreamOutput::writeStringCollection);
        }
    }

    private class ContextPreservingAbstractRunnable
    extends AbstractRunnable
    implements WrappedRunnable {
        private final AbstractRunnable in;
        private final StoredContext creatorsContext;
        private final boolean useNewTraceContext;
        private StoredContext threadsOriginalContext = null;

        private ContextPreservingAbstractRunnable(AbstractRunnable in, boolean useNewTraceContext) {
            this.creatorsContext = ThreadContext.this.newStoredContext();
            this.in = in;
            this.useNewTraceContext = useNewTraceContext;
        }

        @Override
        public boolean isForceExecution() {
            return this.in.isForceExecution();
        }

        @Override
        public void onAfter() {
            try {
                this.in.onAfter();
            }
            finally {
                if (this.threadsOriginalContext != null) {
                    this.threadsOriginalContext.restore();
                }
            }
        }

        @Override
        public void onFailure(Exception e) {
            this.in.onFailure(e);
        }

        @Override
        public void onRejection(Exception e) {
            this.in.onRejection(e);
        }

        @Override
        protected void doRun() throws Exception {
            this.threadsOriginalContext = ThreadContext.this.stashContext();
            this.creatorsContext.restore();
            if (this.useNewTraceContext) {
                ThreadContext.this.newTraceContext();
            }
            this.in.doRun();
        }

        public String toString() {
            return this.in.toString();
        }

        @Override
        public AbstractRunnable unwrap() {
            return this.in;
        }
    }

    private class ContextPreservingRunnable
    implements WrappedRunnable {
        private final Runnable in;
        private final StoredContext ctx;

        private ContextPreservingRunnable(Runnable in) {
            this.ctx = ThreadContext.this.newStoredContext();
            this.in = in;
        }

        @Override
        public void run() {
            try (StoredContext ignore = ThreadContext.this.restoreExistingContext(this.ctx);){
                this.in.run();
            }
        }

        public String toString() {
            return this.in.toString();
        }

        @Override
        public Runnable unwrap() {
            return this.in;
        }
    }
}

