/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.local;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.TimeValue;

public abstract class LocalClusterStateRequest
extends ActionRequest {
    private final TimeValue masterTimeout;

    protected LocalClusterStateRequest(TimeValue masterTimeout) {
        this.masterTimeout = Objects.requireNonNull(masterTimeout);
    }

    protected LocalClusterStateRequest(StreamInput in) throws IOException {
        super(in);
        this.masterTimeout = in.readTimeValue();
        if (in.getTransportVersion().onOrAfter(TransportVersions.V_8_15_0)) {
            in.readVLong();
        }
        in.readBoolean();
    }

    @Override
    public final void writeTo(StreamOutput out) throws IOException {
        TransportAction.localOnly();
    }

    public TimeValue masterTimeout() {
        return this.masterTimeout;
    }
}

