/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchTimeoutException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ContextPreservingActionListener;
import org.elasticsearch.action.support.ThreadedActionListener;
import org.elasticsearch.common.CheckedBiConsumer;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.util.concurrent.UncategorizedExecutionException;
import org.elasticsearch.core.CheckedConsumer;
import org.elasticsearch.core.CheckedFunction;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.threadpool.Scheduler;
import org.elasticsearch.threadpool.ThreadPool;

public class SubscribableListener<T>
implements ActionListener<T> {
    private static final Logger logger = LogManager.getLogger(SubscribableListener.class);
    private static final Object EMPTY = new Object();
    private volatile Object state;
    private static final VarHandle VH_STATE_FIELD;

    public SubscribableListener() {
        this(EMPTY);
    }

    public static <T> SubscribableListener<T> newSucceeded(T result) {
        return new SubscribableListener<T>(new SuccessResult<T>(result));
    }

    public static <T> SubscribableListener<T> newFailed(Exception exception) {
        return new SubscribableListener<T>(new FailureResult(exception, exception));
    }

    public static <T> SubscribableListener<T> newForked(CheckedConsumer<ActionListener<T>, ? extends Exception> fork) {
        SubscribableListener<T> listener = new SubscribableListener<T>();
        ActionListener.run(listener, arg_0 -> fork.accept(arg_0));
        return listener;
    }

    private SubscribableListener(Object initialState) {
        this.state = initialState;
    }

    public final void addListener(ActionListener<T> listener) {
        this.addListener(listener, EsExecutors.DIRECT_EXECUTOR_SERVICE, null);
    }

    public final void addListener(ActionListener<T> listener, Executor executor, @Nullable ThreadContext threadContext) {
        if (SubscribableListener.tryComplete(this.state, listener)) {
            return;
        }
        ActionListener<T> wrappedListener = SubscribableListener.fork(executor, SubscribableListener.preserveContext(threadContext, listener));
        Object currentValue = this.compareAndExchangeState(EMPTY, wrappedListener);
        if (currentValue == EMPTY) {
            return;
        }
        Cell newCell = null;
        while (true) {
            if (SubscribableListener.tryComplete(currentValue, listener)) {
                return;
            }
            if (currentValue instanceof ActionListener) {
                ActionListener firstListener = (ActionListener)currentValue;
                Cell tail = new Cell(firstListener, null);
                if ((currentValue = this.compareAndExchangeState(firstListener, tail)) != firstListener) continue;
                currentValue = tail;
                continue;
            }
            if (currentValue instanceof Cell) {
                Cell headCell = (Cell)currentValue;
                if (newCell == null) {
                    newCell = new Cell(wrappedListener, headCell);
                } else {
                    newCell.next = headCell;
                }
                if ((currentValue = this.compareAndExchangeState(headCell, newCell)) != headCell) continue;
                return;
            }
            if (!$assertionsDisabled) break;
        }
        throw new AssertionError((Object)("unexpected witness: " + String.valueOf(currentValue)));
    }

    @Override
    public final void onResponse(T result) {
        this.setResult(new SuccessResult<T>(result));
    }

    @Override
    public final void onFailure(Exception exception) {
        this.setResult(new FailureResult(exception, this.wrapException(exception)));
    }

    protected Exception wrapException(Exception exception) {
        return exception;
    }

    public final boolean isDone() {
        return SubscribableListener.isDone(this.state);
    }

    protected final T rawResult() throws Exception {
        Object currentState = this.state;
        if (currentState instanceof SuccessResult) {
            SuccessResult result = (SuccessResult)currentState;
            return result.result();
        }
        if (currentState instanceof FailureResult) {
            FailureResult result = (FailureResult)currentState;
            throw result.exception();
        }
        assert (false) : "not done";
        throw new IllegalStateException("listener is not done, cannot get result yet");
    }

    protected static RuntimeException wrapAsExecutionException(Throwable t) {
        if (t instanceof RuntimeException) {
            RuntimeException runtimeException = (RuntimeException)t;
            return runtimeException;
        }
        return new UncategorizedExecutionException("Failed execution", new ExecutionException(t));
    }

    private static <T> ActionListener<T> preserveContext(@Nullable ThreadContext threadContext, ActionListener<T> listener) {
        return threadContext == null ? listener : ContextPreservingActionListener.wrapPreservingContext(listener, threadContext);
    }

    private static <T> ActionListener<T> fork(Executor executor, ActionListener<T> listener) {
        return executor == EsExecutors.DIRECT_EXECUTOR_SERVICE ? listener : new ThreadedActionListener(executor, listener);
    }

    private static <T> boolean tryComplete(Object currentState, ActionListener<T> listener) {
        if (currentState instanceof SuccessResult) {
            SuccessResult successResult = (SuccessResult)currentState;
            successResult.complete(listener);
            return true;
        }
        if (currentState instanceof FailureResult) {
            FailureResult failureResult = (FailureResult)currentState;
            failureResult.complete(listener);
            return true;
        }
        return false;
    }

    private void setResult(Object result) {
        assert (SubscribableListener.isDone(result));
        Object currentState = this.state;
        while (!SubscribableListener.isDone(currentState)) {
            Object witness = this.compareAndExchangeState(currentState, result);
            if (witness == currentState) {
                if (currentState instanceof ActionListener) {
                    ActionListener listener = (ActionListener)currentState;
                    boolean completed = SubscribableListener.tryComplete(result, listener);
                    assert (completed);
                } else if (currentState instanceof Cell) {
                    Cell currCell = (Cell)currentState;
                    Cell prevCell = null;
                    while (true) {
                        Cell nextCell = currCell.next;
                        currCell.next = prevCell;
                        if (nextCell == null) break;
                        prevCell = currCell;
                        currCell = nextCell;
                    }
                    while (currCell != null) {
                        boolean completed = SubscribableListener.tryComplete(result, currCell.listener);
                        assert (completed);
                        currCell = currCell.next;
                    }
                } else assert (currentState == EMPTY) : "unexpected witness: " + String.valueOf(currentState);
                return;
            }
            currentState = witness;
        }
        return;
    }

    private static boolean isDone(Object currentState) {
        return currentState instanceof SuccessResult || currentState instanceof FailureResult;
    }

    public <U> SubscribableListener<U> andThen(CheckedConsumer<ActionListener<U>, ? extends Exception> nextStep) {
        return SubscribableListener.newForked(l -> this.addListener(l.delegateFailureIgnoreResponseAndWrap(nextStep)));
    }

    public <U> SubscribableListener<U> andThen(CheckedBiConsumer<ActionListener<U>, T, ? extends Exception> nextStep) {
        return this.andThen(EsExecutors.DIRECT_EXECUTOR_SERVICE, null, nextStep);
    }

    public <U> SubscribableListener<U> andThen(Executor executor, @Nullable ThreadContext threadContext, CheckedBiConsumer<ActionListener<U>, T, ? extends Exception> nextStep) {
        return SubscribableListener.newForked(l -> this.addListener(l.delegateFailureAndWrap(nextStep), executor, threadContext));
    }

    public <U> SubscribableListener<U> andThenApply(CheckedFunction<T, U, Exception> fn) {
        return SubscribableListener.newForked(l -> this.addListener(l.map(fn)));
    }

    public SubscribableListener<Void> andThenAccept(CheckedConsumer<T, Exception> consumer) {
        return SubscribableListener.newForked(l -> this.addListener(l.map(r -> {
            consumer.accept(r);
            return null;
        })));
    }

    public void addTimeout(TimeValue timeout, ThreadPool threadPool, Executor timeoutExecutor) {
        if (this.isDone()) {
            return;
        }
        this.addListener(ActionListener.running(this.scheduleTimeout(timeout, threadPool, timeoutExecutor)));
    }

    private Runnable scheduleTimeout(TimeValue timeout, ThreadPool threadPool, Executor timeoutExecutor) {
        try {
            Scheduler.ScheduledCancellable cancellable = threadPool.schedule(() -> this.onFailure(new ElasticsearchTimeoutException(Strings.format("timed out after [%s/%dms]", timeout, timeout.millis()), new Object[0])), timeout, timeoutExecutor);
            return cancellable::cancel;
        }
        catch (Exception e) {
            this.onFailure(e);
            return () -> {};
        }
    }

    private Object compareAndExchangeState(Object expectedValue, Object newValue) {
        return VH_STATE_FIELD.compareAndExchange(this, expectedValue, newValue);
    }

    static {
        try {
            VH_STATE_FIELD = MethodHandles.lookup().in(SubscribableListener.class).findVarHandle(SubscribableListener.class, "state", Object.class);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    private record SuccessResult<T>(T result) {
        public void complete(ActionListener<T> listener) {
            block2: {
                try {
                    listener.onResponse(this.result);
                }
                catch (Exception exception) {
                    logger.error(Strings.format("exception thrown while handling response in listener [%s]", listener), (Throwable)exception);
                    if ($assertionsDisabled) break block2;
                    throw new AssertionError((Object)exception);
                }
            }
        }
    }

    private record FailureResult(Exception exception, Exception wrappedException) {
        public void complete(ActionListener<?> listener) {
            block3: {
                try {
                    listener.onFailure(this.wrappedException);
                }
                catch (Exception innerException) {
                    if (this.wrappedException != innerException) {
                        innerException.addSuppressed(this.wrappedException);
                    }
                    logger.error(Strings.format("exception thrown while handling another exception in listener [%s]", listener), (Throwable)innerException);
                    if ($assertionsDisabled) break block3;
                    throw new AssertionError((Object)innerException);
                }
            }
        }
    }

    private static class Cell {
        final ActionListener<?> listener;
        Cell next;

        Cell(ActionListener<?> listener, Cell next) {
            this.listener = listener;
            this.next = next;
        }
    }
}

