/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.template.get;

import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.template.get.GetComposableIndexTemplateAction;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.ChannelActionListener;
import org.elasticsearch.action.support.local.TransportLocalClusterStateAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.ComposableIndexTemplate;
import org.elasticsearch.cluster.metadata.DataStreamLifecycle;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;

public class TransportGetComposableIndexTemplateAction
extends TransportLocalClusterStateAction<GetComposableIndexTemplateAction.Request, GetComposableIndexTemplateAction.Response> {
    private final ClusterSettings clusterSettings;

    @Inject
    public TransportGetComposableIndexTemplateAction(TransportService transportService, ClusterService clusterService, ActionFilters actionFilters) {
        super("indices:admin/index_template/get", actionFilters, transportService.getTaskManager(), clusterService, EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.clusterSettings = clusterService.getClusterSettings();
        transportService.registerRequestHandler(this.actionName, this.executor, false, true, GetComposableIndexTemplateAction.Request::new, (request, channel, task) -> this.executeDirect(task, request, new ChannelActionListener(channel)));
    }

    @Override
    protected ClusterBlockException checkBlock(GetComposableIndexTemplateAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }

    @Override
    protected void localClusterStateOperation(Task task, GetComposableIndexTemplateAction.Request request, ClusterState state, ActionListener<GetComposableIndexTemplateAction.Response> listener) {
        Map<String, ComposableIndexTemplate> results;
        CancellableTask cancellableTask = (CancellableTask)task;
        Map<String, ComposableIndexTemplate> allTemplates = state.metadata().templatesV2();
        if (request.name() == null) {
            results = allTemplates;
        } else {
            results = new HashMap<String, ComposableIndexTemplate>();
            String name = request.name();
            if (Regex.isSimpleMatchPattern(name)) {
                for (Map.Entry<String, ComposableIndexTemplate> entry : allTemplates.entrySet()) {
                    if (!Regex.simpleMatch(name, entry.getKey())) continue;
                    results.put(entry.getKey(), entry.getValue());
                }
            } else if (allTemplates.containsKey(name)) {
                results.put(name, allTemplates.get(name));
            } else {
                throw new ResourceNotFoundException("index template matching [" + request.name() + "] not found", new Object[0]);
            }
        }
        cancellableTask.ensureNotCancelled();
        if (request.includeDefaults()) {
            listener.onResponse(new GetComposableIndexTemplateAction.Response(results, this.clusterSettings.get(DataStreamLifecycle.CLUSTER_LIFECYCLE_DEFAULT_ROLLOVER_SETTING)));
        } else {
            listener.onResponse(new GetComposableIndexTemplateAction.Response(results));
        }
    }
}

