/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.snapshots.get;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ChunkedToXContentObject;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.snapshots.SnapshotInfo;
import org.elasticsearch.xcontent.ToXContent;

public class GetSnapshotsResponse
extends ActionResponse
implements ChunkedToXContentObject {
    private final List<SnapshotInfo> snapshots;
    @Nullable
    private final String next;
    private final int total;
    private final int remaining;

    public GetSnapshotsResponse(List<SnapshotInfo> snapshots, @Nullable String next, int total, int remaining) {
        this.snapshots = List.copyOf(snapshots);
        this.next = next;
        this.total = total;
        this.remaining = remaining;
    }

    public GetSnapshotsResponse(StreamInput in) throws IOException {
        this.snapshots = in.readCollectionAsImmutableList(SnapshotInfo::readFrom);
        if (in.getTransportVersion().before(TransportVersions.REMOVE_SNAPSHOT_FAILURES_90)) {
            in.readMap(StreamInput::readException);
        }
        this.next = in.readOptionalString();
        this.total = in.readVInt();
        this.remaining = in.readVInt();
    }

    public List<SnapshotInfo> getSnapshots() {
        return this.snapshots;
    }

    @Nullable
    public String next() {
        return this.next;
    }

    public int totalCount() {
        return this.total;
    }

    public int remaining() {
        return this.remaining;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeCollection(this.snapshots);
        if (out.getTransportVersion().before(TransportVersions.REMOVE_SNAPSHOT_FAILURES_90)) {
            out.writeMap(Map.of(), StreamOutput::writeException);
        }
        out.writeOptionalString(this.next);
        out.writeVInt(this.total);
        out.writeVInt(this.remaining);
    }

    public Iterator<ToXContent> toXContentChunked(ToXContent.Params params) {
        return Iterators.concat(Iterators.single((b, p) -> {
            b.startObject();
            b.startArray("snapshots");
            return b;
        }), Iterators.map(this.getSnapshots().iterator(), snapshotInfo -> snapshotInfo::toXContentExternal), Iterators.single((b, p) -> {
            b.endArray();
            if (this.next != null) {
                b.field("next", this.next);
            }
            if (this.total >= 0) {
                b.field("total", this.total);
            }
            if (this.remaining >= 0) {
                b.field("remaining", this.remaining);
            }
            b.endObject();
            return b;
        }));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetSnapshotsResponse that = (GetSnapshotsResponse)o;
        return Objects.equals(this.snapshots, that.snapshots) && Objects.equals(this.next, that.next);
    }

    public int hashCode() {
        return Objects.hash(this.snapshots, this.next);
    }

    public String toString() {
        return Strings.toString(this);
    }
}

