/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.rank.rrf;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.builder.SubSearchSourceBuilder;
import org.elasticsearch.search.rank.RankBuilder;
import org.elasticsearch.search.rank.RankDoc;
import org.elasticsearch.search.rank.context.QueryPhaseRankCoordinatorContext;
import org.elasticsearch.search.rank.context.QueryPhaseRankShardContext;
import org.elasticsearch.search.rank.context.RankFeaturePhaseRankCoordinatorContext;
import org.elasticsearch.search.rank.context.RankFeaturePhaseRankShardContext;
import org.elasticsearch.search.retriever.CompoundRetrieverBuilder;
import org.elasticsearch.search.retriever.KnnRetrieverBuilder;
import org.elasticsearch.search.retriever.RetrieverBuilder;
import org.elasticsearch.search.retriever.StandardRetrieverBuilder;
import org.elasticsearch.search.vectors.KnnSearchBuilder;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.XPackPlugin;
import org.elasticsearch.xpack.rank.rrf.RRFQueryPhaseRankCoordinatorContext;
import org.elasticsearch.xpack.rank.rrf.RRFQueryPhaseRankShardContext;
import org.elasticsearch.xpack.rank.rrf.RRFRankDoc;
import org.elasticsearch.xpack.rank.rrf.RRFRankPlugin;
import org.elasticsearch.xpack.rank.rrf.RRFRetrieverBuilder;

@Deprecated
public class RRFRankBuilder
extends RankBuilder {
    public static final ParseField RANK_CONSTANT_FIELD = new ParseField("rank_constant", new String[0]);
    static final ConstructingObjectParser<RRFRankBuilder, Void> PARSER = new ConstructingObjectParser("rrf", args -> {
        int windowSize = args[0] == null ? 10 : (Integer)args[0];
        int rankConstant = args[1] == null ? 60 : (Integer)args[1];
        return new RRFRankBuilder(windowSize, rankConstant);
    });
    private final int rankConstant;

    public static RRFRankBuilder fromXContent(XContentParser parser) throws IOException {
        if (!RRFRankPlugin.RANK_RRF_FEATURE.check(XPackPlugin.getSharedLicenseState())) {
            throw LicenseUtils.newComplianceException((String)"Reciprocal Rank Fusion (RRF)");
        }
        return (RRFRankBuilder)((Object)PARSER.parse(parser, null));
    }

    public void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(RANK_CONSTANT_FIELD.getPreferredName(), this.rankConstant);
    }

    public RRFRankBuilder(int rankWindowSize, int rankConstant) {
        super(rankWindowSize);
        if (rankConstant < 1) {
            throw new IllegalArgumentException("[rank_constant] must be greater or equal to [1] for [rrf]");
        }
        this.rankConstant = rankConstant;
    }

    public RRFRankBuilder(StreamInput in) throws IOException {
        super(in);
        this.rankConstant = in.readVInt();
    }

    public void doWriteTo(StreamOutput out) throws IOException {
        out.writeVInt(this.rankConstant);
    }

    public String getWriteableName() {
        return "rrf";
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.V_8_8_0;
    }

    public int rankConstant() {
        return this.rankConstant;
    }

    public boolean isCompoundBuilder() {
        return true;
    }

    public Explanation explainHit(Explanation baseExplanation, RankDoc rankDoc, List<String> queryNames) {
        Explanation hitExplanation;
        if (rankDoc == null) {
            return baseExplanation;
        }
        if (!baseExplanation.isMatch()) {
            return baseExplanation;
        }
        Explanation explanation = hitExplanation = baseExplanation.getDetails().length == 0 ? Explanation.match((Number)baseExplanation.getValue(), (String)baseExplanation.getDescription(), (Explanation[])new Explanation[]{baseExplanation}) : baseExplanation;
        assert (rankDoc instanceof RRFRankDoc) : "ScoreDoc is not an instance of RRFRankDoc";
        RRFRankDoc rrfRankDoc = (RRFRankDoc)rankDoc;
        int queries = rrfRankDoc.positions.length;
        assert (queryNames.size() == queries);
        Explanation[] details = new Explanation[queries];
        int queryExplainIndex = 0;
        for (int i = 0; i < queries; ++i) {
            String queryName;
            String string = queryName = queryNames.get(i) != null ? "[" + queryNames.get(i) + "]" : "at index [" + i + "]";
            if (rrfRankDoc.positions[i] == -1) {
                String description = "rrf score: [0], result not found in query " + queryName;
                details[i] = Explanation.noMatch((String)description, (Explanation[])new Explanation[0]);
                continue;
            }
            int rank = rrfRankDoc.positions[i] + 1;
            details[i] = Explanation.match((Number)rank, (String)("rrf score: [" + 1.0f / (float)(rank + this.rankConstant) + "], for rank [" + rank + "] in query " + queryName + " computed as [1 / (" + rank + " + " + this.rankConstant + "]), for matching query with score: "), (Explanation[])new Explanation[]{hitExplanation.getDetails()[queryExplainIndex++]});
        }
        return Explanation.match((Number)Float.valueOf(rrfRankDoc.score), (String)("rrf score: [" + rrfRankDoc.score + "] computed for initial ranks " + Arrays.toString(Arrays.stream(rrfRankDoc.positions).map(x -> x + 1).toArray()) + " with rankConstant: [" + this.rankConstant + "] as sum of [1 / (rank + rankConstant)] for each query"), (Explanation[])details);
    }

    public QueryPhaseRankShardContext buildQueryPhaseShardContext(List<Query> queries, int from) {
        return new RRFQueryPhaseRankShardContext(queries, this.rankWindowSize(), this.rankConstant);
    }

    public QueryPhaseRankCoordinatorContext buildQueryPhaseCoordinatorContext(int size, int from) {
        return new RRFQueryPhaseRankCoordinatorContext(size, from, this.rankWindowSize(), this.rankConstant);
    }

    public RankFeaturePhaseRankShardContext buildRankFeaturePhaseShardContext() {
        return null;
    }

    public RankFeaturePhaseRankCoordinatorContext buildRankFeaturePhaseCoordinatorContext(int size, int from, Client client) {
        return null;
    }

    public RetrieverBuilder toRetriever(SearchSourceBuilder source, Predicate<NodeFeature> clusterSupportsFeature) {
        int i;
        int totalQueries = source.subSearches().size() + source.knnSearch().size();
        if (totalQueries < 2) {
            throw new IllegalArgumentException("[rrf] requires at least 2 sub-queries to be defined");
        }
        ArrayList<CompoundRetrieverBuilder.RetrieverSource> retrieverSources = new ArrayList<CompoundRetrieverBuilder.RetrieverSource>(totalQueries);
        for (i = 0; i < source.subSearches().size(); ++i) {
            StandardRetrieverBuilder standardRetriever = new StandardRetrieverBuilder(((SubSearchSourceBuilder)source.subSearches().get(i)).getQueryBuilder());
            standardRetriever.retrieverName(((SubSearchSourceBuilder)source.subSearches().get(i)).getQueryBuilder().queryName());
            retrieverSources.add(new CompoundRetrieverBuilder.RetrieverSource((RetrieverBuilder)standardRetriever, null));
        }
        for (i = 0; i < source.knnSearch().size(); ++i) {
            KnnSearchBuilder knnSearchBuilder = (KnnSearchBuilder)source.knnSearch().get(i);
            KnnRetrieverBuilder knnRetriever = new KnnRetrieverBuilder(knnSearchBuilder.getField(), knnSearchBuilder.getQueryVector().asFloatVector(), knnSearchBuilder.getQueryVectorBuilder(), knnSearchBuilder.k(), knnSearchBuilder.getNumCands(), knnSearchBuilder.getRescoreVectorBuilder(), knnSearchBuilder.getSimilarity());
            knnRetriever.retrieverName(knnSearchBuilder.queryName());
            retrieverSources.add(new CompoundRetrieverBuilder.RetrieverSource((RetrieverBuilder)knnRetriever, null));
        }
        return new RRFRetrieverBuilder(retrieverSources, this.rankWindowSize(), this.rankConstant());
    }

    protected boolean doEquals(RankBuilder other) {
        return Objects.equals(this.rankConstant, ((RRFRankBuilder)other).rankConstant);
    }

    protected int doHashCode() {
        return Objects.hash(this.rankConstant);
    }

    static {
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), RANK_WINDOW_SIZE_FIELD);
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), RANK_CONSTANT_FIELD);
    }
}

