/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.entitlement.bootstrap;

import com.sun.tools.attach.AgentInitializationException;
import com.sun.tools.attach.AgentLoadException;
import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.VirtualMachine;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.PathUtils;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.entitlement.initialization.EntitlementInitialization;
import org.elasticsearch.entitlement.runtime.policy.PathLookup;
import org.elasticsearch.entitlement.runtime.policy.PathLookupImpl;
import org.elasticsearch.entitlement.runtime.policy.Policy;
import org.elasticsearch.entitlement.runtime.policy.PolicyManager;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;

public class EntitlementBootstrap {
    private static BootstrapArgs bootstrapArgs;
    private static final Logger logger;

    public static BootstrapArgs bootstrapArgs() {
        return bootstrapArgs;
    }

    public static void bootstrap(Policy serverPolicyPatch, Map<String, Policy> pluginPolicies, Function<Class<?>, PolicyManager.PolicyScope> scopeResolver, Function<String, Stream<String>> settingResolver, Path[] dataDirs, Path sharedDataDir, Path[] sharedRepoDirs, Path configDir, Path libDir, Path modulesDir, Path pluginsDir, Map<String, Path> sourcePaths, Path logsDir, Path tempDir, Path pidFile, Set<Package> suppressFailureLogPackages) {
        logger.debug("Loading entitlement agent");
        if (bootstrapArgs != null) {
            throw new IllegalStateException("plugin data is already set");
        }
        bootstrapArgs = new BootstrapArgs(serverPolicyPatch, pluginPolicies, scopeResolver, new PathLookupImpl(EntitlementBootstrap.getUserHome(), configDir, dataDirs, sharedDataDir, sharedRepoDirs, libDir, modulesDir, pluginsDir, logsDir, tempDir, pidFile, settingResolver), sourcePaths, suppressFailureLogPackages);
        EntitlementBootstrap.exportInitializationToAgent();
        EntitlementBootstrap.loadAgent(EntitlementBootstrap.findAgentJar());
    }

    private static Path getUserHome() {
        String userHome = System.getProperty("user.home");
        if (userHome == null) {
            throw new IllegalStateException("user.home system property is required");
        }
        return PathUtils.get((String)userHome, (String[])new String[0]);
    }

    @SuppressForbidden(reason="The VirtualMachine API is the only way to attach a java agent dynamically")
    private static void loadAgent(String agentPath) {
        try {
            VirtualMachine vm = VirtualMachine.attach(Long.toString(ProcessHandle.current().pid()));
            try {
                vm.loadAgent(agentPath, EntitlementInitialization.class.getName());
            }
            finally {
                vm.detach();
            }
        }
        catch (AgentInitializationException | AgentLoadException | AttachNotSupportedException | IOException e) {
            throw new IllegalStateException("Unable to attach entitlement agent [" + agentPath + "]", e);
        }
    }

    private static void exportInitializationToAgent() {
        String initPkg = EntitlementInitialization.class.getPackageName();
        Module unnamedModule = ClassLoader.getSystemClassLoader().getUnnamedModule();
        EntitlementInitialization.class.getModule().addExports(initPkg, unnamedModule);
    }

    public static String findAgentJar() {
        String string;
        block11: {
            String propertyName = "es.entitlement.agentJar";
            String propertyValue = System.getProperty(propertyName);
            if (propertyValue != null) {
                return propertyValue;
            }
            Path dir = Path.of("lib", "entitlement-agent");
            if (!Files.exists(dir, new LinkOption[0])) {
                throw new IllegalStateException("Directory for entitlement jar does not exist: " + String.valueOf(dir));
            }
            Stream<Path> s = Files.list(dir);
            try {
                List<Path> candidates = s.limit(2L).toList();
                if (candidates.size() != 1) {
                    throw new IllegalStateException("Expected one jar in " + String.valueOf(dir) + "; found " + candidates.size());
                }
                string = candidates.get(0).toString();
                if (s == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (s != null) {
                        try {
                            s.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalStateException("Failed to list entitlement jars in: " + String.valueOf(dir), e);
                }
            }
            s.close();
        }
        return string;
    }

    static {
        logger = LogManager.getLogger(EntitlementBootstrap.class);
    }

    public record BootstrapArgs(@Nullable Policy serverPolicyPatch, Map<String, Policy> pluginPolicies, Function<Class<?>, PolicyManager.PolicyScope> scopeResolver, PathLookup pathLookup, Map<String, Path> sourcePaths, Set<Package> suppressFailureLogPackages) {
        public BootstrapArgs {
            Objects.requireNonNull(pluginPolicies);
            Objects.requireNonNull(scopeResolver);
            Objects.requireNonNull(pathLookup);
            Objects.requireNonNull(sourcePaths);
            Objects.requireNonNull(suppressFailureLogPackages);
        }
    }
}

