/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform.transforms;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.xpack.transform.transforms.TransformContext;
import org.elasticsearch.xpack.transform.transforms.scheduling.TransformScheduler;

class TransformRetryableStartUpListener<Response>
implements TransformScheduler.Listener {
    private final String transformId;
    private final Consumer<ActionListener<Response>> action;
    private final ActionListener<Response> actionListener;
    private final ActionListener<Boolean> retryScheduledListener;
    private final Supplier<Boolean> shouldRetry;
    private final TransformContext context;
    private final AtomicBoolean isFirstRun;
    private final AtomicBoolean shouldRunAction;

    TransformRetryableStartUpListener(String transformId, Consumer<ActionListener<Response>> action, ActionListener<Response> actionListener, ActionListener<Boolean> retryScheduledListener, Supplier<Boolean> shouldRetry, TransformContext context) {
        this.transformId = transformId;
        this.action = action;
        this.actionListener = actionListener;
        this.retryScheduledListener = retryScheduledListener;
        this.shouldRetry = shouldRetry;
        this.context = context;
        this.isFirstRun = new AtomicBoolean(true);
        this.shouldRunAction = new AtomicBoolean(true);
    }

    @Override
    public void triggered(TransformScheduler.Event event) {
        if (this.transformId.equals(event.transformId()) && this.shouldRunAction.compareAndSet(true, false)) {
            this.action.accept(ActionListener.wrap(this::actionSucceeded, this::actionFailed));
        }
    }

    private void actionSucceeded(Response r) {
        this.maybeNotifyRetryListener(false);
        this.markDone();
        this.actionListener.onResponse(r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markDone() {
        TransformContext transformContext = this.context;
        synchronized (transformContext) {
            this.context.resetStartUpFailureCount();
        }
    }

    private void maybeNotifyRetryListener(boolean response) {
        if (this.isFirstRun.compareAndSet(true, false)) {
            this.retryScheduledListener.onResponse((Object)response);
        }
    }

    private void actionFailed(Exception e) {
        if (this.shouldRetry.get().booleanValue()) {
            this.maybeNotifyRetryListener(true);
            this.recordError(e);
            this.shouldRunAction.set(true);
        } else {
            this.maybeNotifyRetryListener(false);
            this.markDone();
            this.actionListener.onFailure(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordError(Exception e) {
        TransformContext transformContext = this.context;
        synchronized (transformContext) {
            this.context.incrementAndGetStartUpFailureCount(e);
        }
    }
}

