/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.aggregations.pipeline;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.elasticsearch.aggregations.pipeline.Derivative;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.AggregationReduceContext;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.InternalMultiBucketAggregation;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.search.aggregations.bucket.histogram.HistogramFactory;
import org.elasticsearch.search.aggregations.pipeline.BucketHelpers;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;

public class DerivativePipelineAggregator
extends PipelineAggregator {
    private final DocValueFormat formatter;
    private final BucketHelpers.GapPolicy gapPolicy;
    private final Double xAxisUnits;

    DerivativePipelineAggregator(String name, String[] bucketsPaths, DocValueFormat formatter, BucketHelpers.GapPolicy gapPolicy, Long xAxisUnits, Map<String, Object> metadata) {
        super(name, bucketsPaths, metadata);
        this.formatter = formatter;
        this.gapPolicy = gapPolicy;
        this.xAxisUnits = xAxisUnits == null ? null : Double.valueOf(xAxisUnits.longValue());
    }

    public InternalAggregation reduce(InternalAggregation aggregation, AggregationReduceContext reduceContext) {
        InternalMultiBucketAggregation histo = (InternalMultiBucketAggregation)aggregation;
        List buckets = histo.getBuckets();
        HistogramFactory factory = (HistogramFactory)histo;
        ArrayList<Object> newBuckets = new ArrayList<Object>();
        Number lastBucketKey = null;
        Double lastBucketValue = null;
        for (InternalMultiBucketAggregation.InternalBucket bucket : buckets) {
            Number thisBucketKey = factory.getKey((MultiBucketsAggregation.Bucket)bucket);
            Double thisBucketValue = BucketHelpers.resolveBucketValue((MultiBucketsAggregation)histo, (InternalMultiBucketAggregation.InternalBucket)bucket, (String)this.bucketsPaths()[0], (BucketHelpers.GapPolicy)this.gapPolicy);
            if (lastBucketValue != null && thisBucketValue != null) {
                double gradient = thisBucketValue - lastBucketValue;
                double xDiff = -1.0;
                if (this.xAxisUnits != null) {
                    xDiff = (thisBucketKey.doubleValue() - lastBucketKey.doubleValue()) / this.xAxisUnits;
                }
                newBuckets.add(factory.createBucket(factory.getKey((MultiBucketsAggregation.Bucket)bucket), bucket.getDocCount(), InternalAggregations.append((InternalAggregations)bucket.getAggregations(), (InternalAggregation)new Derivative(this.name(), gradient, xDiff, this.formatter, this.metadata()))));
            } else {
                newBuckets.add(bucket);
            }
            lastBucketKey = thisBucketKey;
            lastBucketValue = thisBucketValue;
        }
        return factory.createAggregation(newBuckets);
    }
}

