/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring.collector;

import java.util.HashSet;
import java.util.concurrent.TimeoutException;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchTimeoutException;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.support.DefaultShardOperationFailedException;
import org.elasticsearch.action.support.broadcast.BaseBroadcastResponse;
import org.elasticsearch.action.support.nodes.BaseNodeResponse;
import org.elasticsearch.action.support.nodes.BaseNodesResponse;
import org.elasticsearch.action.support.tasks.BaseTasksResponse;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.transport.ReceiveTimeoutTransportException;

public final class TimeoutUtils {
    private TimeoutUtils() {
    }

    public static <T extends BaseNodeResponse> void ensureNoTimeouts(TimeValue collectionTimeout, BaseNodesResponse<T> response) {
        HashSet<String> timedOutNodeIds = null;
        for (FailedNodeException failedNodeException : response.failures()) {
            if (!TimeoutUtils.isTimeoutFailure(failedNodeException)) continue;
            if (timedOutNodeIds == null) {
                timedOutNodeIds = new HashSet<String>();
            }
            timedOutNodeIds.add(failedNodeException.nodeId());
        }
        TimeoutUtils.ensureNoTimeouts(collectionTimeout, timedOutNodeIds);
    }

    public static void ensureNoTimeouts(TimeValue collectionTimeout, BaseTasksResponse response) {
        HashSet<String> timedOutNodeIds = null;
        for (ElasticsearchException nodeFailure : response.getNodeFailures()) {
            FailedNodeException failedNodeException;
            if (!(nodeFailure instanceof FailedNodeException) || !TimeoutUtils.isTimeoutFailure(failedNodeException = (FailedNodeException)nodeFailure)) continue;
            if (timedOutNodeIds == null) {
                timedOutNodeIds = new HashSet<String>();
            }
            timedOutNodeIds.add(failedNodeException.nodeId());
        }
        TimeoutUtils.ensureNoTimeouts(collectionTimeout, timedOutNodeIds);
    }

    public static void ensureNoTimeouts(TimeValue collectionTimeout, BaseBroadcastResponse response) {
        HashSet<String> timedOutNodeIds = null;
        for (DefaultShardOperationFailedException shardFailure : response.getShardFailures()) {
            FailedNodeException failedNodeException;
            Throwable shardFailureCause = shardFailure.getCause();
            if (!(shardFailureCause instanceof FailedNodeException) || !TimeoutUtils.isTimeoutFailure(failedNodeException = (FailedNodeException)shardFailureCause)) continue;
            if (timedOutNodeIds == null) {
                timedOutNodeIds = new HashSet<String>();
            }
            timedOutNodeIds.add(failedNodeException.nodeId());
        }
        TimeoutUtils.ensureNoTimeouts(collectionTimeout, timedOutNodeIds);
    }

    private static boolean isTimeoutFailure(FailedNodeException failedNodeException) {
        Throwable cause = failedNodeException.getCause();
        return cause instanceof ElasticsearchTimeoutException || cause instanceof TimeoutException || cause instanceof ReceiveTimeoutTransportException;
    }

    private static void ensureNoTimeouts(TimeValue collectionTimeout, HashSet<String> timedOutNodeIds) {
        if (timedOutNodeIds != null) {
            throw new ElasticsearchTimeoutException((timedOutNodeIds.size() == 1 ? "node " : "nodes ") + String.valueOf(timedOutNodeIds) + " did not respond within [" + String.valueOf(collectionTimeout) + "]", new Object[0]);
        }
    }
}

