/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.server.cli;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CountDownLatch;
import java.util.function.Predicate;
import org.elasticsearch.cli.Terminal;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.server.cli.ProcessUtil;

class ErrorPumpThread
extends Thread
implements Closeable {
    private final BufferedReader reader;
    private final Terminal terminal;
    private final CountDownLatch readyOrDead = new CountDownLatch(1);
    private volatile boolean ready;
    private volatile IOException ioFailure;
    private static Predicate<String> filter = Regex.simpleMatcher((String[])new String[]{"WARNING: Using incubator modules: jdk.incubator.vector", "WARNING: Use of the three-letter time zone ID * is deprecated and it will be removed in a future release"});

    ErrorPumpThread(Terminal terminal, InputStream errInput) {
        super("server-cli[stderr_pump]");
        this.reader = new BufferedReader(new InputStreamReader(errInput, StandardCharsets.UTF_8));
        this.terminal = terminal;
    }

    private void checkForIoFailure() throws IOException {
        IOException failure = this.ioFailure;
        this.ioFailure = null;
        if (failure != null) {
            throw failure;
        }
    }

    @Override
    public void close() throws IOException {
        assert (!this.isAlive()) : "Pump thread must be drained first";
        this.checkForIoFailure();
    }

    boolean waitUntilReady() throws IOException {
        ProcessUtil.nonInterruptibleVoid(this.readyOrDead::await);
        this.checkForIoFailure();
        return this.ready;
    }

    void drain() {
        ProcessUtil.nonInterruptibleVoid(this::join);
    }

    @Override
    public void run() {
        try {
            String line;
            while ((line = this.reader.readLine()) != null) {
                if (!line.isEmpty() && line.charAt(0) == '\u0018') {
                    this.ready = true;
                    this.readyOrDead.countDown();
                    continue;
                }
                if (filter.test(line)) continue;
                this.terminal.errorPrintln(Terminal.Verbosity.SILENT, line, false);
            }
        }
        catch (IOException e) {
            this.ioFailure = e;
        }
        finally {
            this.terminal.flush();
            this.readyOrDead.countDown();
        }
    }
}

