/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.session;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ResolvedIndices;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.Rewriteable;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.transport.RemoteClusterService;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.expression.function.fulltext.FullTextFunction;
import org.elasticsearch.xpack.esql.plan.logical.EsRelation;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.planner.TranslatorHandler;
import org.elasticsearch.xpack.esql.session.IndexResolver;
import org.elasticsearch.xpack.esql.session.Result;

public class QueryBuilderResolver {
    private final SearchService searchService;
    private final ClusterService clusterService;
    private final TransportService transportService;
    private final IndexNameExpressionResolver indexNameExpressionResolver;

    public QueryBuilderResolver(SearchService searchService, ClusterService clusterService, TransportService transportService, IndexNameExpressionResolver indexNameExpressionResolver) {
        this.searchService = searchService;
        this.clusterService = clusterService;
        this.transportService = transportService;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
    }

    public void resolveQueryBuilders(final LogicalPlan plan, final ActionListener<Result> listener, final BiConsumer<LogicalPlan, ActionListener<Result>> callback) {
        if (!plan.optimized()) {
            listener.onFailure((Exception)new IllegalStateException("Expected optimized plan before query builder rewrite."));
            return;
        }
        Set<FullTextFunction> unresolved = this.fullTextFunctions(plan);
        Set<String> indexNames = this.indexNames(plan);
        if (indexNames == null || indexNames.isEmpty() || unresolved.isEmpty()) {
            callback.accept(plan, listener);
            return;
        }
        QueryRewriteContext ctx = this.queryRewriteContext(indexNames);
        FullTextFunctionsRewritable rewritable = new FullTextFunctionsRewritable(unresolved);
        Rewriteable.rewriteAndFetch((Rewriteable)rewritable, (QueryRewriteContext)ctx, (ActionListener)new ActionListener<FullTextFunctionsRewritable>(){

            public void onResponse(FullTextFunctionsRewritable fullTextFunctionsRewritable) {
                try {
                    LogicalPlan newPlan = QueryBuilderResolver.this.planWithResolvedQueryBuilders(plan, fullTextFunctionsRewritable.results());
                    callback.accept(newPlan, listener);
                }
                catch (Exception e) {
                    this.onFailure(e);
                }
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        });
    }

    private Set<FullTextFunction> fullTextFunctions(LogicalPlan plan) {
        HashSet<FullTextFunction> functions = new HashSet<FullTextFunction>();
        plan.forEachExpressionDown(FullTextFunction.class, func -> functions.add((FullTextFunction)func));
        return functions;
    }

    public Set<String> indexNames(LogicalPlan plan) {
        HashSet<String> indexNames = new HashSet<String>();
        plan.forEachDown(EsRelation.class, esRelation -> indexNames.addAll(esRelation.concreteIndices()));
        return indexNames;
    }

    public LogicalPlan planWithResolvedQueryBuilders(LogicalPlan plan, Map<FullTextFunction, QueryBuilder> newQueryBuilders) {
        LogicalPlan newPlan = (LogicalPlan)((Object)plan.transformExpressionsDown(FullTextFunction.class, m -> {
            if (newQueryBuilders.keySet().contains(m)) {
                return m.replaceQueryBuilder((QueryBuilder)newQueryBuilders.get(m));
            }
            return m;
        }));
        newPlan.setOptimized();
        return newPlan;
    }

    private QueryRewriteContext queryRewriteContext(Set<String> indexNames) {
        ResolvedIndices resolvedIndices = ResolvedIndices.resolveWithIndexNamesAndOptions((String[])((String[])indexNames.toArray(String[]::new)), (IndicesOptions)IndexResolver.FIELD_CAPS_INDICES_OPTIONS, (ClusterState)this.clusterService.state(), (IndexNameExpressionResolver)this.indexNameExpressionResolver, (RemoteClusterService)this.transportService.getRemoteClusterService(), (long)System.currentTimeMillis());
        return this.searchService.getRewriteContext(() -> System.currentTimeMillis(), resolvedIndices, null);
    }

    private class FullTextFunctionsRewritable
    implements Rewriteable<FullTextFunctionsRewritable> {
        private final Map<FullTextFunction, QueryBuilder> queryBuilderMap;

        FullTextFunctionsRewritable(Map<FullTextFunction, QueryBuilder> queryBuilderMap) {
            this.queryBuilderMap = queryBuilderMap;
        }

        FullTextFunctionsRewritable(Set<FullTextFunction> functions) {
            this.queryBuilderMap = new HashMap<FullTextFunction, QueryBuilder>();
            for (FullTextFunction func : functions) {
                this.queryBuilderMap.put(func, TranslatorHandler.TRANSLATOR_HANDLER.asQuery((Expression)func).toQueryBuilder());
            }
        }

        public FullTextFunctionsRewritable rewrite(QueryRewriteContext ctx) throws IOException {
            HashMap<FullTextFunction, QueryBuilder> results = new HashMap<FullTextFunction, QueryBuilder>();
            boolean hasChanged = false;
            for (Map.Entry<FullTextFunction, QueryBuilder> entry : this.queryBuilderMap.entrySet()) {
                QueryBuilder initial = entry.getValue();
                QueryBuilder rewritten = initial.rewrite(ctx);
                hasChanged |= rewritten != initial;
                results.put(entry.getKey(), rewritten);
            }
            return hasChanged ? new FullTextFunctionsRewritable(results) : this;
        }

        public Map<FullTextFunction, QueryBuilder> results() {
            return this.queryBuilderMap;
        }
    }
}

