/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.elasticsearch.xpack.esql.VerificationException;
import org.elasticsearch.xpack.esql.common.Failure;
import org.elasticsearch.xpack.esql.optimizer.PhysicalOptimizerContext;
import org.elasticsearch.xpack.esql.optimizer.PhysicalVerifier;
import org.elasticsearch.xpack.esql.optimizer.rules.physical.ProjectAwayColumns;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.esql.rule.ParameterizedRuleExecutor;
import org.elasticsearch.xpack.esql.rule.RuleExecutor;

public class PhysicalPlanOptimizer
extends ParameterizedRuleExecutor<PhysicalPlan, PhysicalOptimizerContext> {
    private static final Iterable<RuleExecutor.Batch<PhysicalPlan>> rules = PhysicalPlanOptimizer.initializeRules(true);
    private final PhysicalVerifier verifier = PhysicalVerifier.INSTANCE;

    public PhysicalPlanOptimizer(PhysicalOptimizerContext context) {
        super(context);
    }

    public PhysicalPlan optimize(PhysicalPlan plan) {
        return this.verify(this.execute(plan));
    }

    PhysicalPlan verify(PhysicalPlan plan) {
        Collection<Failure> failures = this.verifier.verify(plan);
        if (!failures.isEmpty()) {
            throw new VerificationException(failures);
        }
        return plan;
    }

    static List<RuleExecutor.Batch<PhysicalPlan>> initializeRules(boolean isOptimizedForEsSource) {
        RuleExecutor.Batch boundary = new RuleExecutor.Batch("Plan Boundary", RuleExecutor.Limiter.ONCE, new ProjectAwayColumns());
        return Arrays.asList(boundary);
    }

    @Override
    protected Iterable<RuleExecutor.Batch<PhysicalPlan>> batches() {
        return rules;
    }
}

