/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic;

import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.expression.predicate.BinaryOperator;
import org.elasticsearch.xpack.esql.core.expression.predicate.PredicateBiFunction;
import org.elasticsearch.xpack.esql.core.expression.predicate.operator.arithmetic.BinaryArithmeticOperation;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.type.EsqlDataTypeConverter;

public abstract class ArithmeticOperation
extends BinaryOperator<Object, Object, Object, BinaryArithmeticOperation> {
    private DataType dataType;

    protected ArithmeticOperation(Source source, Expression left, Expression right, BinaryArithmeticOperation operation) {
        super(source, left, right, (PredicateBiFunction)operation);
    }

    protected Expression.TypeResolution resolveInputType(Expression e, TypeResolutions.ParamOrdinal paramOrdinal) {
        return TypeResolutions.isNumeric((Expression)e, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)paramOrdinal);
    }

    public ArithmeticOperation swapLeftAndRight() {
        return this;
    }

    public DataType dataType() {
        if (this.dataType == null) {
            this.dataType = EsqlDataTypeConverter.commonType(this.left().dataType(), this.right().dataType());
        }
        return this.dataType;
    }
}

