/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.conditional;

import java.util.Arrays;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.conditional.Least;

public final class LeastBooleanEvaluator
implements EvalOperator.ExpressionEvaluator {
    private final Source source;
    private final EvalOperator.ExpressionEvaluator[] values;
    private final DriverContext driverContext;
    private Warnings warnings;

    public LeastBooleanEvaluator(Source source, EvalOperator.ExpressionEvaluator[] values, DriverContext driverContext) {
        this.source = source;
        this.values = values;
        this.driverContext = driverContext;
    }

    public Block eval(Page page) {
        BooleanBlock[] valuesBlocks = new BooleanBlock[this.values.length];
        try (Releasable valuesRelease = Releasables.wrap((Releasable[])valuesBlocks);){
            for (int i = 0; i < valuesBlocks.length; ++i) {
                valuesBlocks[i] = (BooleanBlock)this.values[i].eval(page);
            }
            BooleanVector[] valuesVectors = new BooleanVector[this.values.length];
            for (int i = 0; i < valuesBlocks.length; ++i) {
                valuesVectors[i] = valuesBlocks[i].asVector();
                if (valuesVectors[i] != null) continue;
                BooleanBlock booleanBlock = this.eval(page.getPositionCount(), valuesBlocks);
                return booleanBlock;
            }
            BooleanBlock booleanBlock = this.eval(page.getPositionCount(), valuesVectors).asBlock();
            return booleanBlock;
        }
    }

    public BooleanBlock eval(int positionCount, BooleanBlock[] valuesBlocks) {
        try (BooleanBlock.Builder result = this.driverContext.blockFactory().newBooleanBlockBuilder(positionCount);){
            boolean[] valuesValues = new boolean[this.values.length];
            block5: for (int p = 0; p < positionCount; ++p) {
                int i;
                for (i = 0; i < valuesBlocks.length; ++i) {
                    if (valuesBlocks[i].isNull(p)) {
                        result.appendNull();
                        continue block5;
                    }
                    if (valuesBlocks[i].getValueCount(p) == 1) continue;
                    if (valuesBlocks[i].getValueCount(p) > 1) {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue block5;
                }
                for (i = 0; i < valuesBlocks.length; ++i) {
                    int o = valuesBlocks[i].getFirstValueIndex(p);
                    valuesValues[i] = valuesBlocks[i].getBoolean(o);
                }
                result.appendBoolean(Least.process(valuesValues));
            }
            BooleanBlock booleanBlock = result.build();
            return booleanBlock;
        }
    }

    public BooleanVector eval(int positionCount, BooleanVector[] valuesVectors) {
        try (BooleanVector.FixedBuilder result = this.driverContext.blockFactory().newBooleanVectorFixedBuilder(positionCount);){
            boolean[] valuesValues = new boolean[this.values.length];
            for (int p = 0; p < positionCount; ++p) {
                for (int i = 0; i < valuesVectors.length; ++i) {
                    valuesValues[i] = valuesVectors[i].getBoolean(p);
                }
                result.appendBoolean(p, Least.process(valuesValues));
            }
            BooleanVector booleanVector = result.build();
            return booleanVector;
        }
    }

    public String toString() {
        return "LeastBooleanEvaluator[values=" + Arrays.toString(this.values) + "]";
    }

    public void close() {
        Releasables.closeExpectNoException(() -> Releasables.close((Releasable[])this.values));
    }

    private Warnings warnings() {
        if (this.warnings == null) {
            this.warnings = Warnings.createWarnings((DriverContext.WarningsMode)this.driverContext.warningsMode(), (int)this.source.source().getLineNumber(), (int)this.source.source().getColumnNumber(), (String)this.source.text());
        }
        return this.warnings;
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory[] values;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory[] values) {
            this.source = source;
            this.values = values;
        }

        public LeastBooleanEvaluator get(DriverContext context) {
            EvalOperator.ExpressionEvaluator[] values = (EvalOperator.ExpressionEvaluator[])Arrays.stream(this.values).map(a -> a.get(context)).toArray(EvalOperator.ExpressionEvaluator[]::new);
            return new LeastBooleanEvaluator(this.source, values, context);
        }

        public String toString() {
            return "LeastBooleanEvaluator[values=" + Arrays.toString(this.values) + "]";
        }
    }
}

