/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.fulltext;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.querydsl.query.Query;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesTo;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesToLifecycle;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.fulltext.FullTextFunction;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.planner.TranslatorHandler;
import org.elasticsearch.xpack.esql.querydsl.query.KqlQuery;

public class Kql
extends FullTextFunction {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "Kql", Kql::readFrom);

    @FunctionInfo(returnType={"boolean"}, preview=true, appliesTo={@FunctionAppliesTo(lifeCycle=FunctionAppliesToLifecycle.PREVIEW, version="9.0.0"), @FunctionAppliesTo(lifeCycle=FunctionAppliesToLifecycle.GA, version="9.1.0")}, description="Performs a KQL query. Returns true if the provided KQL query string matches the row.", examples={@Example(file="kql-function", tag="kql-with-field")})
    public Kql(Source source, @Param(name="query", type={"keyword", "text"}, description="Query string in KQL query string format.") Expression queryString) {
        super(source, queryString, List.of(queryString), null);
    }

    public Kql(Source source, Expression queryString, QueryBuilder queryBuilder) {
        super(source, queryString, List.of(queryString), queryBuilder);
    }

    private static Kql readFrom(StreamInput in) throws IOException {
        Source source = Source.readFrom((StreamInput)((PlanStreamInput)in));
        Expression query = (Expression)in.readNamedWriteable(Expression.class);
        QueryBuilder queryBuilder = null;
        if (in.getTransportVersion().onOrAfter((VersionId)TransportVersions.ESQL_QUERY_BUILDER_IN_SEARCH_FUNCTIONS)) {
            queryBuilder = (QueryBuilder)in.readOptionalNamedWriteable(QueryBuilder.class);
        }
        return new Kql(source, query, queryBuilder);
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.source().writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.query());
        if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.ESQL_QUERY_BUILDER_IN_SEARCH_FUNCTIONS)) {
            out.writeOptionalNamedWriteable((NamedWriteable)this.queryBuilder());
        }
    }

    public String getWriteableName() {
        return Kql.ENTRY.name;
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new Kql(this.source(), newChildren.get(0), this.queryBuilder());
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, Kql::new, (Object)this.query(), (Object)this.queryBuilder());
    }

    @Override
    protected Query translate(TranslatorHandler handler) {
        return new KqlQuery(this.source(), Objects.toString(this.queryAsObject()));
    }

    @Override
    public Expression replaceQueryBuilder(QueryBuilder queryBuilder) {
        return new Kql(this.source(), this.query(), queryBuilder);
    }
}

