/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.aggregate;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.esql.capabilities.PostAnalysisPlanVerificationAware;
import org.elasticsearch.xpack.esql.common.Failure;
import org.elasticsearch.xpack.esql.common.Failures;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.FoldContext;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.expression.function.Function;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.util.CollectionUtils;
import org.elasticsearch.xpack.esql.expression.function.aggregate.Rate;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.plan.logical.Aggregate;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;

public abstract class AggregateFunction
extends Function
implements PostAnalysisPlanVerificationAware {
    private final Expression field;
    private final List<? extends Expression> parameters;
    private final Expression filter;

    protected AggregateFunction(Source source, Expression field) {
        this(source, field, (Expression)Literal.TRUE, Collections.emptyList());
    }

    protected AggregateFunction(Source source, Expression field, List<? extends Expression> parameters) {
        this(source, field, (Expression)Literal.TRUE, parameters);
    }

    protected AggregateFunction(Source source, Expression field, Expression filter, List<? extends Expression> parameters) {
        super(source, CollectionUtils.combine(Arrays.asList(field, filter), parameters));
        this.field = field;
        this.filter = filter;
        this.parameters = parameters;
    }

    protected AggregateFunction(StreamInput in) throws IOException {
        this(Source.readFrom((StreamInput)((PlanStreamInput)in)), (Expression)in.readNamedWriteable(Expression.class), (Expression)(in.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_16_0) ? (Expression)in.readNamedWriteable(Expression.class) : Literal.TRUE), in.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_16_0) ? in.readNamedWriteableCollectionAsList(Expression.class) : Collections.emptyList());
    }

    public final void writeTo(StreamOutput out) throws IOException {
        Source.EMPTY.writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.field);
        if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_16_0)) {
            out.writeNamedWriteable((NamedWriteable)this.filter);
            out.writeNamedWriteableCollection(this.parameters);
        } else {
            this.deprecatedWriteParams(out);
        }
    }

    @Deprecated(since="8.16", forRemoval=true)
    protected void deprecatedWriteParams(StreamOutput out) throws IOException {
    }

    public Expression field() {
        return this.field;
    }

    public List<? extends Expression> parameters() {
        return this.parameters;
    }

    public boolean hasFilter() {
        return this.filter != null && (!this.filter.foldable() || !Boolean.TRUE.equals(this.filter.fold(FoldContext.small())));
    }

    public Expression filter() {
        return this.filter;
    }

    protected Expression.TypeResolution resolveType() {
        return TypeResolutions.isExact((Expression)this.field, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.DEFAULT);
    }

    public abstract AggregateFunction withFilter(Expression var1);

    public AggregateFunction withParameters(List<? extends Expression> parameters) {
        if (parameters == this.parameters) {
            return this;
        }
        return (AggregateFunction)this.replaceChildren(CollectionUtils.combine(Arrays.asList(this.field, this.filter), parameters));
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.children());
    }

    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            AggregateFunction other = (AggregateFunction)obj;
            return Objects.equals(other.field(), this.field()) && Objects.equals(other.filter(), this.filter()) && Objects.equals(other.parameters(), this.parameters());
        }
        return false;
    }

    @Override
    public BiConsumer<LogicalPlan, Failures> postAnalysisPlanVerification() {
        return (p, failures) -> {
            if (!(p instanceof Aggregate)) {
                p.expressions().forEach(x -> x.forEachDown(AggregateFunction.class, af -> {
                    if (af instanceof Rate) {
                        failures.add(Failure.fail(af, "aggregate function [{}] not allowed outside METRICS command", new Object[]{af.sourceText()}));
                    } else {
                        failures.add(Failure.fail(af, "aggregate function [{}] not allowed outside STATS command", new Object[]{af.sourceText()}));
                    }
                }));
            }
        };
    }
}

