/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.ibmwatsonx.embeddings;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.http.client.utils.URIBuilder;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.ChunkingSettings;
import org.elasticsearch.inference.EmptyTaskSettings;
import org.elasticsearch.inference.InputType;
import org.elasticsearch.inference.ModelConfigurations;
import org.elasticsearch.inference.ModelSecrets;
import org.elasticsearch.inference.SecretSettings;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.inference.TaskSettings;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.xpack.inference.external.action.ExecutableAction;
import org.elasticsearch.xpack.inference.external.action.ibmwatsonx.IbmWatsonxActionVisitor;
import org.elasticsearch.xpack.inference.services.ConfigurationParseContext;
import org.elasticsearch.xpack.inference.services.ibmwatsonx.IbmWatsonxModel;
import org.elasticsearch.xpack.inference.services.ibmwatsonx.embeddings.IbmWatsonxEmbeddingsServiceSettings;
import org.elasticsearch.xpack.inference.services.settings.DefaultSecretSettings;

public class IbmWatsonxEmbeddingsModel
extends IbmWatsonxModel {
    private URI uri;

    public IbmWatsonxEmbeddingsModel(String inferenceEntityId, TaskType taskType, String service, Map<String, Object> serviceSettings, Map<String, Object> taskSettings, ChunkingSettings chunkingSettings, Map<String, Object> secrets, ConfigurationParseContext context) {
        this(inferenceEntityId, taskType, service, IbmWatsonxEmbeddingsServiceSettings.fromMap(serviceSettings, context), (TaskSettings)EmptyTaskSettings.INSTANCE, chunkingSettings, DefaultSecretSettings.fromMap(secrets));
    }

    public IbmWatsonxEmbeddingsModel(IbmWatsonxEmbeddingsModel model, IbmWatsonxEmbeddingsServiceSettings serviceSettings) {
        super((IbmWatsonxModel)model, serviceSettings);
    }

    IbmWatsonxEmbeddingsModel(String inferenceEntityId, TaskType taskType, String service, IbmWatsonxEmbeddingsServiceSettings serviceSettings, TaskSettings taskSettings, ChunkingSettings chunkingsettings, @Nullable DefaultSecretSettings secrets) {
        super(new ModelConfigurations(inferenceEntityId, taskType, service, (ServiceSettings)serviceSettings, taskSettings, chunkingsettings), new ModelSecrets((SecretSettings)secrets), serviceSettings);
        try {
            this.uri = IbmWatsonxEmbeddingsModel.buildUri(serviceSettings.url().toString(), serviceSettings.apiVersion());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    IbmWatsonxEmbeddingsModel(String inferenceEntityId, TaskType taskType, String service, String uri, IbmWatsonxEmbeddingsServiceSettings serviceSettings, TaskSettings taskSettings, @Nullable DefaultSecretSettings secrets) {
        super(new ModelConfigurations(inferenceEntityId, taskType, service, (ServiceSettings)serviceSettings, taskSettings), new ModelSecrets((SecretSettings)secrets), serviceSettings);
        try {
            this.uri = new URI(uri);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public IbmWatsonxEmbeddingsServiceSettings getServiceSettings() {
        return (IbmWatsonxEmbeddingsServiceSettings)super.getServiceSettings();
    }

    public DefaultSecretSettings getSecretSettings() {
        return (DefaultSecretSettings)super.getSecretSettings();
    }

    public URI uri() {
        return this.uri;
    }

    @Override
    public ExecutableAction accept(IbmWatsonxActionVisitor visitor, Map<String, Object> taskSettings, InputType inputType) {
        return visitor.create(this, taskSettings);
    }

    public static URI buildUri(String uri, String apiVersion) throws URISyntaxException {
        return new URIBuilder().setScheme("https").setHost(uri).setPathSegments(new String[]{"ml", "v1", "text", "embeddings"}).setParameter("version", apiVersion).build();
    }
}

