/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.elastic.authorization;

import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.xpack.inference.external.response.elastic.ElasticInferenceServiceAuthorizationResponseEntity;

public class ElasticInferenceServiceAuthorizationModel {
    private final Map<TaskType, Set<String>> taskTypeToModels;
    private final EnumSet<TaskType> authorizedTaskTypes;
    private final Set<String> authorizedModelIds;

    public static ElasticInferenceServiceAuthorizationModel of(ElasticInferenceServiceAuthorizationResponseEntity responseEntity) {
        HashMap<TaskType, Set<String>> taskTypeToModelsMap = new HashMap<TaskType, Set<String>>();
        EnumSet<TaskType> enabledTaskTypesSet = EnumSet.noneOf(TaskType.class);
        HashSet<String> enabledModelsSet = new HashSet<String>();
        for (ElasticInferenceServiceAuthorizationResponseEntity.AuthorizedModel model : responseEntity.getAuthorizedModels()) {
            if (model.taskTypes().isEmpty()) continue;
            for (TaskType taskType : model.taskTypes()) {
                taskTypeToModelsMap.merge(taskType, Set.of(model.modelName()), (existingModelIds, newModelIds) -> {
                    HashSet combinedNames = new HashSet(existingModelIds);
                    combinedNames.addAll(newModelIds);
                    return combinedNames;
                });
                enabledTaskTypesSet.add(taskType);
            }
            enabledModelsSet.add(model.modelName());
        }
        return new ElasticInferenceServiceAuthorizationModel(taskTypeToModelsMap, enabledModelsSet, enabledTaskTypesSet);
    }

    public static ElasticInferenceServiceAuthorizationModel newDisabledService() {
        return new ElasticInferenceServiceAuthorizationModel(Map.of(), Set.of(), EnumSet.noneOf(TaskType.class));
    }

    private ElasticInferenceServiceAuthorizationModel(Map<TaskType, Set<String>> taskTypeToModels, Set<String> authorizedModelIds, EnumSet<TaskType> authorizedTaskTypes) {
        this.taskTypeToModels = Objects.requireNonNull(taskTypeToModels);
        this.authorizedModelIds = Objects.requireNonNull(authorizedModelIds);
        this.authorizedTaskTypes = Objects.requireNonNull(authorizedTaskTypes);
    }

    public boolean isAuthorized() {
        return !this.authorizedModelIds.isEmpty() && !this.taskTypeToModels.isEmpty() && !this.authorizedTaskTypes.isEmpty();
    }

    public Set<String> getAuthorizedModelIds() {
        return Set.copyOf(this.authorizedModelIds);
    }

    public EnumSet<TaskType> getAuthorizedTaskTypes() {
        return EnumSet.copyOf(this.authorizedTaskTypes);
    }

    public ElasticInferenceServiceAuthorizationModel newLimitedToTaskTypes(EnumSet<TaskType> taskTypes) {
        HashMap<TaskType, Set<String>> newTaskTypeToModels = new HashMap<TaskType, Set<String>>();
        EnumSet<TaskType> taskTypesThatHaveModels = EnumSet.noneOf(TaskType.class);
        for (TaskType taskType : taskTypes) {
            Set<String> models = this.taskTypeToModels.get(taskType);
            if (models == null) continue;
            newTaskTypeToModels.put(taskType, models);
            taskTypesThatHaveModels.add(taskType);
        }
        return new ElasticInferenceServiceAuthorizationModel(newTaskTypeToModels, ElasticInferenceServiceAuthorizationModel.enabledModels(newTaskTypeToModels), taskTypesThatHaveModels);
    }

    private static Set<String> enabledModels(Map<TaskType, Set<String>> taskTypeToModels) {
        return taskTypeToModels.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public ElasticInferenceServiceAuthorizationModel merge(ElasticInferenceServiceAuthorizationModel other) {
        Map<TaskType, Set<String>> newTaskTypeToModels = this.taskTypeToModels.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new HashSet((Collection)e.getValue())));
        for (Map.Entry<TaskType, Set<String>> entry : other.taskTypeToModels.entrySet()) {
            newTaskTypeToModels.merge(entry.getKey(), new HashSet(entry.getValue()), (existingModelIds, newModelIds) -> {
                existingModelIds.addAll(newModelIds);
                return existingModelIds;
            });
        }
        EnumSet<TaskType> newAuthorizedTaskTypes = this.authorizedTaskTypes.isEmpty() ? EnumSet.noneOf(TaskType.class) : EnumSet.copyOf(this.authorizedTaskTypes);
        newAuthorizedTaskTypes.addAll(other.authorizedTaskTypes);
        return new ElasticInferenceServiceAuthorizationModel(newTaskTypeToModels, ElasticInferenceServiceAuthorizationModel.enabledModels(newTaskTypeToModels), newAuthorizedTaskTypes);
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ElasticInferenceServiceAuthorizationModel that = (ElasticInferenceServiceAuthorizationModel)o;
        return Objects.equals(this.taskTypeToModels, that.taskTypeToModels) && Objects.equals(this.authorizedTaskTypes, that.authorizedTaskTypes) && Objects.equals(this.authorizedModelIds, that.authorizedModelIds);
    }

    public int hashCode() {
        return Objects.hash(this.taskTypeToModels, this.authorizedTaskTypes, this.authorizedModelIds);
    }

    public String toString() {
        return "{taskTypeToModels=" + String.valueOf(this.taskTypeToModels) + ", authorizedTaskTypes=" + String.valueOf(this.authorizedTaskTypes) + ", authorizedModelIds=" + String.valueOf(this.authorizedModelIds) + "}";
    }
}

