/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.anthropic.completion;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.http.client.utils.URIBuilder;
import org.elasticsearch.common.CheckedSupplier;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.ModelConfigurations;
import org.elasticsearch.inference.ModelSecrets;
import org.elasticsearch.inference.SecretSettings;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.inference.TaskSettings;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.xpack.inference.external.action.ExecutableAction;
import org.elasticsearch.xpack.inference.external.action.anthropic.AnthropicActionVisitor;
import org.elasticsearch.xpack.inference.services.ConfigurationParseContext;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.anthropic.AnthropicModel;
import org.elasticsearch.xpack.inference.services.anthropic.completion.AnthropicChatCompletionRequestTaskSettings;
import org.elasticsearch.xpack.inference.services.anthropic.completion.AnthropicChatCompletionServiceSettings;
import org.elasticsearch.xpack.inference.services.anthropic.completion.AnthropicChatCompletionTaskSettings;
import org.elasticsearch.xpack.inference.services.settings.DefaultSecretSettings;

public class AnthropicChatCompletionModel
extends AnthropicModel {
    public static AnthropicChatCompletionModel of(AnthropicChatCompletionModel model, Map<String, Object> taskSettings) {
        if (taskSettings == null || taskSettings.isEmpty()) {
            return model;
        }
        AnthropicChatCompletionRequestTaskSettings requestTaskSettings = AnthropicChatCompletionRequestTaskSettings.fromMap(taskSettings);
        return new AnthropicChatCompletionModel(model, AnthropicChatCompletionTaskSettings.of(model.getTaskSettings(), requestTaskSettings));
    }

    public AnthropicChatCompletionModel(String inferenceEntityId, TaskType taskType, String service, Map<String, Object> serviceSettings, Map<String, Object> taskSettings, @Nullable Map<String, Object> secrets, ConfigurationParseContext context) {
        this(inferenceEntityId, taskType, service, AnthropicChatCompletionServiceSettings.fromMap(serviceSettings, context), AnthropicChatCompletionTaskSettings.fromMap(taskSettings, context), DefaultSecretSettings.fromMap(secrets));
    }

    AnthropicChatCompletionModel(String inferenceEntityId, TaskType taskType, String service, AnthropicChatCompletionServiceSettings serviceSettings, AnthropicChatCompletionTaskSettings taskSettings, @Nullable DefaultSecretSettings secrets) {
        super(new ModelConfigurations(inferenceEntityId, taskType, service, (ServiceSettings)serviceSettings, (TaskSettings)taskSettings), new ModelSecrets((SecretSettings)secrets), serviceSettings, (CheckedSupplier<URI, URISyntaxException>)((CheckedSupplier)AnthropicChatCompletionModel::buildDefaultUri), secrets);
    }

    AnthropicChatCompletionModel(String inferenceEntityId, TaskType taskType, String service, String url, AnthropicChatCompletionServiceSettings serviceSettings, AnthropicChatCompletionTaskSettings taskSettings, @Nullable DefaultSecretSettings secrets) {
        super(new ModelConfigurations(inferenceEntityId, taskType, service, (ServiceSettings)serviceSettings, (TaskSettings)taskSettings), new ModelSecrets((SecretSettings)secrets), serviceSettings, (CheckedSupplier<URI, URISyntaxException>)((CheckedSupplier)() -> ServiceUtils.createUri(url)), secrets);
    }

    private AnthropicChatCompletionModel(AnthropicChatCompletionModel originalModel, AnthropicChatCompletionTaskSettings taskSettings) {
        super((AnthropicModel)originalModel, taskSettings);
    }

    public AnthropicChatCompletionServiceSettings getServiceSettings() {
        return (AnthropicChatCompletionServiceSettings)super.getServiceSettings();
    }

    public AnthropicChatCompletionTaskSettings getTaskSettings() {
        return (AnthropicChatCompletionTaskSettings)super.getTaskSettings();
    }

    public DefaultSecretSettings getSecretSettings() {
        return (DefaultSecretSettings)super.getSecretSettings();
    }

    @Override
    public ExecutableAction accept(AnthropicActionVisitor creator, Map<String, Object> taskSettings) {
        return creator.create(this, taskSettings);
    }

    private static URI buildDefaultUri() throws URISyntaxException {
        return new URIBuilder().setScheme("https").setHost("api.anthropic.com").setPathSegments(new String[]{"v1", "messages"}).build();
    }
}

