/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.rank.textsimilarity;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.search.ScoreDoc;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.rank.RankBuilder;
import org.elasticsearch.search.rank.RankDoc;
import org.elasticsearch.search.retriever.CompoundRetrieverBuilder;
import org.elasticsearch.search.retriever.RetrieverBuilder;
import org.elasticsearch.search.retriever.RetrieverParserContext;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.inference.rank.textsimilarity.TextSimilarityRankBuilder;
import org.elasticsearch.xpack.inference.rank.textsimilarity.TextSimilarityRankDoc;

public class TextSimilarityRankRetrieverBuilder
extends CompoundRetrieverBuilder<TextSimilarityRankRetrieverBuilder> {
    public static final NodeFeature TEXT_SIMILARITY_RERANKER_ALIAS_HANDLING_FIX = new NodeFeature("text_similarity_reranker_alias_handling_fix");
    public static final NodeFeature TEXT_SIMILARITY_RERANKER_MINSCORE_FIX = new NodeFeature("text_similarity_reranker_minscore_fix");
    public static final ParseField RETRIEVER_FIELD = new ParseField("retriever", new String[0]);
    public static final ParseField INFERENCE_ID_FIELD = new ParseField("inference_id", new String[0]);
    public static final ParseField INFERENCE_TEXT_FIELD = new ParseField("inference_text", new String[0]);
    public static final ParseField FIELD_FIELD = new ParseField("field", new String[0]);
    public static final ConstructingObjectParser<TextSimilarityRankRetrieverBuilder, RetrieverParserContext> PARSER = new ConstructingObjectParser("text_similarity_reranker", args -> {
        RetrieverBuilder retrieverBuilder = (RetrieverBuilder)args[0];
        String inferenceId = args[1] == null ? ".rerank-v1-elasticsearch" : (String)args[1];
        String inferenceText = (String)args[2];
        String field = (String)args[3];
        int rankWindowSize = args[4] == null ? 10 : (Integer)args[4];
        return new TextSimilarityRankRetrieverBuilder(retrieverBuilder, inferenceId, inferenceText, field, rankWindowSize);
    });
    private final String inferenceId;
    private final String inferenceText;
    private final String field;

    public static TextSimilarityRankRetrieverBuilder fromXContent(XContentParser parser, RetrieverParserContext context, XPackLicenseState licenceState) throws IOException {
        if (!TextSimilarityRankBuilder.TEXT_SIMILARITY_RERANKER_FEATURE.check(licenceState)) {
            throw LicenseUtils.newComplianceException((String)"text_similarity_reranker");
        }
        return (TextSimilarityRankRetrieverBuilder)((Object)PARSER.apply(parser, (Object)context));
    }

    public TextSimilarityRankRetrieverBuilder(RetrieverBuilder retrieverBuilder, String inferenceId, String inferenceText, String field, int rankWindowSize) {
        super(List.of(new CompoundRetrieverBuilder.RetrieverSource(retrieverBuilder, null)), rankWindowSize);
        this.inferenceId = inferenceId;
        this.inferenceText = inferenceText;
        this.field = field;
    }

    public TextSimilarityRankRetrieverBuilder(List<CompoundRetrieverBuilder.RetrieverSource> retrieverSource, String inferenceId, String inferenceText, String field, int rankWindowSize, Float minScore, String retrieverName, List<QueryBuilder> preFilterQueryBuilders) {
        super(retrieverSource, rankWindowSize);
        if (retrieverSource.size() != 1) {
            throw new IllegalArgumentException("[" + this.getName() + "] retriever should have exactly one inner retriever");
        }
        this.inferenceId = inferenceId;
        this.inferenceText = inferenceText;
        this.field = field;
        this.minScore = minScore;
        this.retrieverName = retrieverName;
        this.preFilterQueryBuilders = preFilterQueryBuilders;
    }

    protected TextSimilarityRankRetrieverBuilder clone(List<CompoundRetrieverBuilder.RetrieverSource> newChildRetrievers, List<QueryBuilder> newPreFilterQueryBuilders) {
        return new TextSimilarityRankRetrieverBuilder(newChildRetrievers, this.inferenceId, this.inferenceText, this.field, this.rankWindowSize, this.minScore, this.retrieverName, newPreFilterQueryBuilders);
    }

    protected RankDoc[] combineInnerRetrieverResults(List<ScoreDoc[]> rankResults, boolean explain) {
        assert (rankResults.size() == 1);
        ScoreDoc[] scoreDocs = rankResults.getFirst();
        ArrayList<TextSimilarityRankDoc> filteredDocs = new ArrayList<TextSimilarityRankDoc>();
        for (int i = 0; i < scoreDocs.length; ++i) {
            ScoreDoc scoreDoc = scoreDocs[i];
            assert (scoreDoc.score >= 0.0f);
            if (this.minScore != null && !(scoreDoc.score >= this.minScore.floatValue())) continue;
            if (explain) {
                filteredDocs.add(new TextSimilarityRankDoc(scoreDoc.doc, scoreDoc.score, scoreDoc.shardIndex, this.inferenceId, this.field));
                continue;
            }
            filteredDocs.add(new TextSimilarityRankDoc(scoreDoc.doc, scoreDoc.score, scoreDoc.shardIndex));
        }
        return filteredDocs.toArray(new TextSimilarityRankDoc[0]);
    }

    protected SearchSourceBuilder finalizeSourceBuilder(SearchSourceBuilder sourceBuilder) {
        sourceBuilder.rankBuilder((RankBuilder)new TextSimilarityRankBuilder(this.field, this.inferenceId, this.inferenceText, this.rankWindowSize, this.minScore));
        return sourceBuilder;
    }

    public String getName() {
        return "text_similarity_reranker";
    }

    public String inferenceId() {
        return this.inferenceId;
    }

    protected void doToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(RETRIEVER_FIELD.getPreferredName(), (ToXContent)((CompoundRetrieverBuilder.RetrieverSource)this.innerRetrievers.getFirst()).retriever());
        builder.field(INFERENCE_ID_FIELD.getPreferredName(), this.inferenceId);
        builder.field(INFERENCE_TEXT_FIELD.getPreferredName(), this.inferenceText);
        builder.field(FIELD_FIELD.getPreferredName(), this.field);
        builder.field(RANK_WINDOW_SIZE_FIELD.getPreferredName(), this.rankWindowSize);
    }

    public boolean doEquals(Object other) {
        TextSimilarityRankRetrieverBuilder that = (TextSimilarityRankRetrieverBuilder)((Object)other);
        return super.doEquals(other) && Objects.equals(this.inferenceId, that.inferenceId) && Objects.equals(this.inferenceText, that.inferenceText) && Objects.equals(this.field, that.field) && Objects.equals(this.rankWindowSize, that.rankWindowSize) && Objects.equals(this.minScore, that.minScore);
    }

    public int doHashCode() {
        return Objects.hash(this.inferenceId, this.inferenceText, this.field, this.rankWindowSize, this.minScore);
    }

    static {
        PARSER.declareNamedObject(ConstructingObjectParser.constructorArg(), (p, c, n) -> {
            RetrieverBuilder innerRetriever = (RetrieverBuilder)p.namedObject(RetrieverBuilder.class, n, c);
            c.trackRetrieverUsage(innerRetriever.getName());
            return innerRetriever;
        }, RETRIEVER_FIELD);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), INFERENCE_ID_FIELD);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), INFERENCE_TEXT_FIELD);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), FIELD_FIELD);
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), RANK_WINDOW_SIZE_FIELD);
        RetrieverBuilder.declareBaseParserFields((String)"text_similarity_reranker", PARSER);
    }
}

