/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.rank.random;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.rank.RankBuilder;
import org.elasticsearch.search.rank.RankDoc;
import org.elasticsearch.search.rank.context.QueryPhaseRankCoordinatorContext;
import org.elasticsearch.search.rank.context.QueryPhaseRankShardContext;
import org.elasticsearch.search.rank.context.RankFeaturePhaseRankCoordinatorContext;
import org.elasticsearch.search.rank.context.RankFeaturePhaseRankShardContext;
import org.elasticsearch.search.rank.feature.RankFeatureDoc;
import org.elasticsearch.search.rank.rerank.RerankingQueryPhaseRankCoordinatorContext;
import org.elasticsearch.search.rank.rerank.RerankingQueryPhaseRankShardContext;
import org.elasticsearch.search.rank.rerank.RerankingRankFeaturePhaseRankShardContext;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.rank.random.RandomRankFeaturePhaseRankCoordinatorContext;
import org.elasticsearch.xpack.inference.rank.random.RandomRankRetrieverBuilder;

public class RandomRankBuilder
extends RankBuilder {
    public static final String NAME = "random_reranker";
    static final ConstructingObjectParser<RandomRankBuilder, Void> PARSER = new ConstructingObjectParser("random_reranker", args -> {
        Integer rankWindowSize = args[0] == null ? 10 : (Integer)args[0];
        String field = (String)args[1];
        Integer seed = (Integer)args[2];
        return new RandomRankBuilder(rankWindowSize, field, seed);
    });
    private final String field;
    private final Integer seed;

    public RandomRankBuilder(int rankWindowSize, String field, Integer seed) {
        super(rankWindowSize);
        if (field == null || field.isEmpty()) {
            throw new IllegalArgumentException("field is required");
        }
        this.field = field;
        this.seed = seed;
    }

    public RandomRankBuilder(StreamInput in) throws IOException {
        super(in);
        this.field = in.readString();
        this.seed = in.readOptionalInt();
    }

    public String getWriteableName() {
        return NAME;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.V_8_16_0;
    }

    public void doWriteTo(StreamOutput out) throws IOException {
        out.writeString(this.field);
        out.writeOptionalInt(this.seed);
    }

    public void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(RandomRankRetrieverBuilder.FIELD_FIELD.getPreferredName(), this.field);
        if (this.seed != null) {
            builder.field(RandomRankRetrieverBuilder.SEED_FIELD.getPreferredName(), this.seed);
        }
    }

    public boolean isCompoundBuilder() {
        return false;
    }

    public Explanation explainHit(Explanation baseExplanation, RankDoc scoreDoc, List<String> queryNames) {
        if (scoreDoc == null) {
            return baseExplanation;
        }
        if (!baseExplanation.isMatch()) {
            return baseExplanation;
        }
        assert (scoreDoc instanceof RankFeatureDoc) : "ScoreDoc is not an instance of RankFeatureDoc";
        RankFeatureDoc rankFeatureDoc = (RankFeatureDoc)scoreDoc;
        return Explanation.match((Number)Float.valueOf(rankFeatureDoc.score), (String)("rank after reranking: [" + rankFeatureDoc.rank + "] using seed [" + this.seed + "] with score: [" + rankFeatureDoc.score + "]"), (Explanation[])new Explanation[]{baseExplanation});
    }

    public QueryPhaseRankShardContext buildQueryPhaseShardContext(List<Query> queries, int from) {
        return new RerankingQueryPhaseRankShardContext(queries, this.rankWindowSize());
    }

    public QueryPhaseRankCoordinatorContext buildQueryPhaseCoordinatorContext(int size, int from) {
        return new RerankingQueryPhaseRankCoordinatorContext(this.rankWindowSize());
    }

    public RankFeaturePhaseRankShardContext buildRankFeaturePhaseShardContext() {
        return new RerankingRankFeaturePhaseRankShardContext(this.field);
    }

    public RankFeaturePhaseRankCoordinatorContext buildRankFeaturePhaseCoordinatorContext(int size, int from, Client client) {
        return new RandomRankFeaturePhaseRankCoordinatorContext(size, from, this.rankWindowSize(), this.seed);
    }

    public String field() {
        return this.field;
    }

    protected boolean doEquals(RankBuilder other) {
        RandomRankBuilder that = (RandomRankBuilder)other;
        return Objects.equals(this.field, that.field) && Objects.equals(this.seed, that.seed);
    }

    protected int doHashCode() {
        return Objects.hash(this.field, this.seed);
    }

    static {
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), RANK_WINDOW_SIZE_FIELD);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), RandomRankRetrieverBuilder.FIELD_FIELD);
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), RandomRankRetrieverBuilder.SEED_FIELD);
    }
}

