/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.request.googlevertexai;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public record GoogleVertexAiRerankRequestEntity(String query, List<String> inputs, @Nullable String model, @Nullable Integer topN) implements ToXContentObject
{
    private static final String MODEL_FIELD = "model";
    private static final String QUERY_FIELD = "query";
    private static final String RECORDS_FIELD = "records";
    private static final String ID_FIELD = "id";
    private static final String CONTENT_FIELD = "content";
    private static final String TOP_N_FIELD = "topN";

    public GoogleVertexAiRerankRequestEntity {
        Objects.requireNonNull(query);
        Objects.requireNonNull(inputs);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.model != null) {
            builder.field(MODEL_FIELD, this.model);
        }
        builder.field(QUERY_FIELD, this.query);
        builder.startArray(RECORDS_FIELD);
        for (int recordId = 0; recordId < this.inputs.size(); ++recordId) {
            builder.startObject();
            builder.field(ID_FIELD, String.valueOf(recordId));
            builder.field(CONTENT_FIELD, this.inputs.get(recordId));
            builder.endObject();
        }
        builder.endArray();
        if (this.topN != null) {
            builder.field(TOP_N_FIELD, this.topN);
        }
        builder.endObject();
        return builder;
    }
}

