/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.request.elastic;

import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.message.BasicHeader;
import org.elasticsearch.common.Strings;
import org.elasticsearch.inference.InputType;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.inference.common.Truncator;
import org.elasticsearch.xpack.inference.external.request.HttpRequest;
import org.elasticsearch.xpack.inference.external.request.Request;
import org.elasticsearch.xpack.inference.external.request.elastic.ElasticInferenceServiceRequest;
import org.elasticsearch.xpack.inference.external.request.elastic.ElasticInferenceServiceSparseEmbeddingsRequestEntity;
import org.elasticsearch.xpack.inference.services.elastic.ElasticInferenceServiceSparseEmbeddingsModel;
import org.elasticsearch.xpack.inference.services.elastic.ElasticInferenceServiceUsageContext;
import org.elasticsearch.xpack.inference.telemetry.TraceContext;
import org.elasticsearch.xpack.inference.telemetry.TraceContextHandler;

public class ElasticInferenceServiceSparseEmbeddingsRequest
implements ElasticInferenceServiceRequest {
    private final URI uri;
    private final ElasticInferenceServiceSparseEmbeddingsModel model;
    private final Truncator.TruncationResult truncationResult;
    private final Truncator truncator;
    private final TraceContextHandler traceContextHandler;
    private final InputType inputType;

    public ElasticInferenceServiceSparseEmbeddingsRequest(Truncator truncator, Truncator.TruncationResult truncationResult, ElasticInferenceServiceSparseEmbeddingsModel model, TraceContext traceContext, InputType inputType) {
        this.truncator = truncator;
        this.truncationResult = truncationResult;
        this.model = Objects.requireNonNull(model);
        this.uri = model.uri();
        this.traceContextHandler = new TraceContextHandler(traceContext);
        this.inputType = inputType;
    }

    @Override
    public HttpRequest createHttpRequest() {
        HttpPost httpPost = new HttpPost(this.uri);
        ElasticInferenceServiceUsageContext usageContext = ElasticInferenceServiceSparseEmbeddingsRequest.inputTypeToUsageContext(this.inputType);
        String requestEntity = Strings.toString((ToXContent)new ElasticInferenceServiceSparseEmbeddingsRequestEntity(this.truncationResult.input(), this.model.getServiceSettings().modelId(), usageContext));
        ByteArrayEntity byteEntity = new ByteArrayEntity(requestEntity.getBytes(StandardCharsets.UTF_8));
        httpPost.setEntity((HttpEntity)byteEntity);
        this.traceContextHandler.propagateTraceContext((HttpRequestBase)httpPost);
        httpPost.setHeader((Header)new BasicHeader("Content-Type", XContentType.JSON.mediaType()));
        return new HttpRequest((HttpRequestBase)httpPost, this.getInferenceEntityId());
    }

    public TraceContext getTraceContext() {
        return this.traceContextHandler.traceContext();
    }

    @Override
    public String getInferenceEntityId() {
        return this.model.getInferenceEntityId();
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    @Override
    public Request truncate() {
        Truncator.TruncationResult truncatedInput = this.truncator.truncate(this.truncationResult.input());
        return new ElasticInferenceServiceSparseEmbeddingsRequest(this.truncator, truncatedInput, this.model, this.traceContextHandler.traceContext(), this.inputType);
    }

    @Override
    public boolean[] getTruncationInfo() {
        return (boolean[])this.truncationResult.truncated().clone();
    }

    static ElasticInferenceServiceUsageContext inputTypeToUsageContext(InputType inputType) {
        switch (inputType) {
            case SEARCH: {
                return ElasticInferenceServiceUsageContext.SEARCH;
            }
            case INGEST: {
                return ElasticInferenceServiceUsageContext.INGEST;
            }
        }
        return ElasticInferenceServiceUsageContext.UNSPECIFIED;
    }
}

