/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.request.amazonbedrock.completion;

import java.util.List;
import java.util.Objects;
import org.elasticsearch.xpack.inference.external.request.amazonbedrock.completion.AmazonBedrockConverseRequestEntity;
import org.elasticsearch.xpack.inference.external.request.amazonbedrock.completion.AmazonBedrockConverseUtils;
import org.elasticsearch.xpack.inference.services.amazonbedrock.completion.AmazonBedrockChatCompletionModel;
import org.elasticsearch.xpack.inference.services.amazonbedrock.completion.AmazonBedrockChatCompletionServiceSettings;
import org.elasticsearch.xpack.inference.services.amazonbedrock.completion.AmazonBedrockChatCompletionTaskSettings;

public final class AmazonBedrockChatCompletionEntityFactory {
    public static AmazonBedrockConverseRequestEntity createEntity(AmazonBedrockChatCompletionModel model, List<String> messages) {
        Objects.requireNonNull(model);
        Objects.requireNonNull(messages);
        AmazonBedrockChatCompletionServiceSettings serviceSettings = model.getServiceSettings();
        AmazonBedrockChatCompletionTaskSettings taskSettings = model.getTaskSettings();
        switch (serviceSettings.provider()) {
            case AI21LABS: 
            case AMAZONTITAN: 
            case META: {
                return new AmazonBedrockConverseRequestEntity(messages, taskSettings.temperature(), taskSettings.topP(), taskSettings.maxNewTokens());
            }
            case ANTHROPIC: 
            case COHERE: 
            case MISTRAL: {
                return new AmazonBedrockConverseRequestEntity(messages, taskSettings.temperature(), taskSettings.topP(), taskSettings.maxNewTokens(), AmazonBedrockConverseUtils.additionalTopK(taskSettings.topK()));
            }
        }
        return null;
    }
}

