/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.http.sender;

import java.util.List;
import java.util.Objects;
import org.elasticsearch.inference.UnifiedCompletionRequest;
import org.elasticsearch.xpack.inference.external.http.sender.ChatCompletionInput;
import org.elasticsearch.xpack.inference.external.http.sender.InferenceInputs;

public class UnifiedChatInput
extends InferenceInputs {
    private final UnifiedCompletionRequest request;

    public UnifiedChatInput(UnifiedCompletionRequest request, boolean stream) {
        super(stream);
        this.request = Objects.requireNonNull(request);
    }

    public UnifiedChatInput(ChatCompletionInput completionInput, String roleValue) {
        this(completionInput.getInputs(), roleValue, completionInput.stream());
    }

    public UnifiedChatInput(List<String> inputs, String roleValue, boolean stream) {
        this(UnifiedCompletionRequest.of(UnifiedChatInput.convertToMessages(inputs, roleValue)), stream);
    }

    private static List<UnifiedCompletionRequest.Message> convertToMessages(List<String> inputs, String roleValue) {
        return inputs.stream().map(value -> new UnifiedCompletionRequest.Message((UnifiedCompletionRequest.Content)new UnifiedCompletionRequest.ContentString(value), roleValue, null, null)).toList();
    }

    public UnifiedCompletionRequest getRequest() {
        return this.request;
    }

    @Override
    public int inputSize() {
        return this.request.messages().size();
    }
}

