/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.action.alibabacloudsearch;

import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xpack.inference.external.action.ActionUtils;
import org.elasticsearch.xpack.inference.external.action.ExecutableAction;
import org.elasticsearch.xpack.inference.external.alibabacloudsearch.AlibabaCloudSearchAccount;
import org.elasticsearch.xpack.inference.external.http.sender.AlibabaCloudSearchCompletionRequestManager;
import org.elasticsearch.xpack.inference.external.http.sender.ChatCompletionInput;
import org.elasticsearch.xpack.inference.external.http.sender.InferenceInputs;
import org.elasticsearch.xpack.inference.external.http.sender.Sender;
import org.elasticsearch.xpack.inference.services.ServiceComponents;
import org.elasticsearch.xpack.inference.services.alibabacloudsearch.completion.AlibabaCloudSearchCompletionModel;

public class AlibabaCloudSearchCompletionAction
implements ExecutableAction {
    private static final Logger logger = LogManager.getLogger(AlibabaCloudSearchCompletionAction.class);
    private final AlibabaCloudSearchAccount account;
    private final AlibabaCloudSearchCompletionModel model;
    private final String failedToSendRequestErrorMessage;
    private final Sender sender;
    private final AlibabaCloudSearchCompletionRequestManager requestCreator;

    public AlibabaCloudSearchCompletionAction(Sender sender, AlibabaCloudSearchCompletionModel model, ServiceComponents serviceComponents) {
        this.model = Objects.requireNonNull(model);
        this.sender = Objects.requireNonNull(sender);
        this.account = new AlibabaCloudSearchAccount(this.model.getSecretSettings().apiKey());
        this.failedToSendRequestErrorMessage = ActionUtils.constructFailedToSendRequestMessage("AlibabaCloud Search completion");
        this.requestCreator = AlibabaCloudSearchCompletionRequestManager.of(this.account, model, serviceComponents.threadPool());
    }

    @Override
    public void execute(InferenceInputs inferenceInputs, TimeValue timeout, ActionListener<InferenceServiceResults> listener) {
        ChatCompletionInput completionInput = inferenceInputs.castTo(ChatCompletionInput.class);
        if (completionInput.getInputs().size() % 2 == 0) {
            listener.onFailure((Exception)new ElasticsearchStatusException("Alibaba Completion's inputs must be an odd number. The last input is the current query, all preceding inputs are the completion history as pairs of user input and the assistant's response.", RestStatus.BAD_REQUEST, new Object[0]));
            return;
        }
        try {
            ActionListener<InferenceServiceResults> wrappedListener = ActionUtils.wrapFailuresInElasticsearchException(this.failedToSendRequestErrorMessage, listener);
            this.sender.send(this.requestCreator, inferenceInputs, timeout, wrappedListener);
        }
        catch (ElasticsearchException e) {
            listener.onFailure((Exception)((Object)e));
        }
        catch (Exception e) {
            listener.onFailure((Exception)ActionUtils.createInternalServerError(e, this.failedToSendRequestErrorMessage));
        }
    }
}

