/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.action;

import java.io.IOException;
import java.util.concurrent.Executor;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.inference.UnparsedModel;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.inference.action.InferenceAction;
import org.elasticsearch.xpack.core.inference.action.InferenceActionProxy;
import org.elasticsearch.xpack.core.inference.action.UnifiedCompletionAction;
import org.elasticsearch.xpack.core.inference.results.UnifiedChatCompletionException;
import org.elasticsearch.xpack.inference.registry.ModelRegistry;

public class TransportInferenceActionProxy
extends HandledTransportAction<InferenceActionProxy.Request, InferenceAction.Response> {
    private final ModelRegistry modelRegistry;
    private final Client client;

    @Inject
    public TransportInferenceActionProxy(TransportService transportService, ActionFilters actionFilters, ModelRegistry modelRegistry, Client client) {
        super("cluster:monitor/xpack/inference/post", transportService, actionFilters, InferenceActionProxy.Request::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.modelRegistry = modelRegistry;
        this.client = client;
    }

    protected void doExecute(Task task, InferenceActionProxy.Request request, ActionListener<InferenceAction.Response> listener) {
        try {
            ActionListener getModelListener = listener.delegateFailureAndWrap((l, unparsedModel) -> {
                if (unparsedModel.taskType() == TaskType.CHAT_COMPLETION) {
                    this.sendUnifiedCompletionRequest(request, (ActionListener<InferenceAction.Response>)l);
                } else {
                    this.sendInferenceActionRequest(request, (ActionListener<InferenceAction.Response>)l);
                }
            });
            if (request.getTaskType() == TaskType.ANY) {
                this.modelRegistry.getModelWithSecrets(request.getInferenceEntityId(), (ActionListener<UnparsedModel>)getModelListener);
            } else if (request.getTaskType() == TaskType.CHAT_COMPLETION) {
                this.sendUnifiedCompletionRequest(request, listener);
            } else {
                this.sendInferenceActionRequest(request, listener);
            }
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    private void sendUnifiedCompletionRequest(InferenceActionProxy.Request request, ActionListener<InferenceAction.Response> listener) {
        ActionListener unifiedErrorFormatListener = listener.delegateResponse((l, e) -> l.onFailure((Exception)UnifiedChatCompletionException.fromThrowable((Throwable)e)));
        try {
            UnifiedCompletionAction.Request unifiedRequest;
            if (!request.isStreaming()) {
                throw new ElasticsearchStatusException("The [chat_completion] task type only supports streaming, please try again with the _stream API", RestStatus.BAD_REQUEST, new Object[0]);
            }
            try (XContentParser parser = XContentHelper.createParser((XContentParserConfiguration)XContentParserConfiguration.EMPTY, (BytesReference)request.getContent(), (XContentType)request.getContentType());){
                unifiedRequest = UnifiedCompletionAction.Request.parseRequest((String)request.getInferenceEntityId(), (TaskType)request.getTaskType(), (TimeValue)request.getTimeout(), (XContentParser)parser);
            }
            ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"inference", (ActionType)UnifiedCompletionAction.INSTANCE, (ActionRequest)unifiedRequest, (ActionListener)unifiedErrorFormatListener);
        }
        catch (Exception e2) {
            unifiedErrorFormatListener.onFailure(e2);
        }
    }

    private void sendInferenceActionRequest(InferenceActionProxy.Request request, ActionListener<InferenceAction.Response> listener) throws IOException {
        InferenceAction.Request.Builder inferenceActionRequestBuilder;
        try (XContentParser parser = XContentHelper.createParser((XContentParserConfiguration)XContentParserConfiguration.EMPTY, (BytesReference)request.getContent(), (XContentType)request.getContentType());){
            inferenceActionRequestBuilder = InferenceAction.Request.parseRequest((String)request.getInferenceEntityId(), (TaskType)request.getTaskType(), (XContentParser)parser);
            inferenceActionRequestBuilder.setInferenceTimeout(request.getTimeout()).setStream(request.isStreaming());
        }
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"inference", (ActionType)InferenceAction.INSTANCE, (ActionRequest)inferenceActionRequestBuilder.build(), listener);
    }
}

