/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.common.http;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.watcher.common.secret.Secret;
import org.elasticsearch.xpack.core.watcher.support.xcontent.WatcherParams;
import org.elasticsearch.xpack.core.watcher.support.xcontent.WatcherXContentParser;

public class BasicAuth
implements ToXContentObject {
    public static final String TYPE = "basic";
    final String username;
    final Secret password;

    public BasicAuth(String username, char[] password) {
        this(username, new Secret(password));
    }

    public BasicAuth(String username, Secret password) {
        this.username = username;
        this.password = password;
    }

    public String getUsername() {
        return this.username;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BasicAuth other = (BasicAuth)o;
        return Objects.equals(this.username, other.username) && Objects.equals(this.password, other.password);
    }

    public int hashCode() {
        return Objects.hash(this.username, this.password);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(Field.USERNAME.getPreferredName(), this.username);
        if (this.password != null) {
            if (WatcherParams.hideSecrets((ToXContent.Params)params) && !this.password.value().startsWith("::es_encrypted::")) {
                builder.field(Field.PASSWORD.getPreferredName(), "::es_redacted::");
            } else {
                builder.field(Field.PASSWORD.getPreferredName(), this.password.value());
            }
        }
        return builder.endObject();
    }

    public static BasicAuth parseInner(XContentParser parser) throws IOException {
        XContentParser.Token token;
        String username = null;
        Secret password = null;
        String fieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                fieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.VALUE_STRING) {
                if (Field.USERNAME.getPreferredName().equals(fieldName)) {
                    username = parser.text();
                    continue;
                }
                if (Field.PASSWORD.getPreferredName().equals(fieldName)) {
                    password = WatcherXContentParser.secretOrNull((XContentParser)parser);
                    continue;
                }
                throw new ElasticsearchParseException("unsupported field [" + fieldName + "]", new Object[0]);
            }
            throw new ElasticsearchParseException("unsupported token [" + String.valueOf(token) + "]", new Object[0]);
        }
        if (username == null) {
            throw new ElasticsearchParseException("username is a required option", new Object[0]);
        }
        return new BasicAuth(username, password);
    }

    public static BasicAuth parse(XContentParser parser) throws IOException {
        XContentParser.Token token;
        String type = null;
        BasicAuth auth = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                type = parser.currentName();
                continue;
            }
            if (token != XContentParser.Token.START_OBJECT || type == null) continue;
            auth = BasicAuth.parseInner(parser);
        }
        return auth;
    }

    static interface Field {
        public static final ParseField USERNAME = new ParseField("username", new String[0]);
        public static final ParseField PASSWORD = new ParseField("password", new String[0]);
    }
}

