/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.predicate.conditional;

import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.Expressions;
import org.elasticsearch.xpack.ql.expression.gen.pipeline.Pipe;
import org.elasticsearch.xpack.ql.expression.gen.script.ParamsBuilder;
import org.elasticsearch.xpack.ql.expression.gen.script.ScriptTemplate;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.sql.expression.predicate.conditional.ConditionalFunction;
import org.elasticsearch.xpack.sql.expression.predicate.conditional.ConditionalPipe;
import org.elasticsearch.xpack.sql.expression.predicate.conditional.ConditionalProcessor;

public abstract class ArbitraryConditionalFunction
extends ConditionalFunction {
    private final ConditionalProcessor.ConditionalOperation operation;

    ArbitraryConditionalFunction(Source source, List<Expression> fields, ConditionalProcessor.ConditionalOperation operation) {
        super(source, fields);
        this.operation = operation;
    }

    protected Pipe makePipe() {
        return new ConditionalPipe(this.source(), (Expression)this, Expressions.pipe((List)this.children()), this.operation);
    }

    public ScriptTemplate asScript() {
        ArrayList<ScriptTemplate> templates = new ArrayList<ScriptTemplate>();
        for (Expression ex : this.children()) {
            templates.add(this.asScript(ex));
        }
        StringJoiner template = new StringJoiner(",", "{sql}." + this.operation.scriptMethodName() + "([", "])");
        ParamsBuilder params = ParamsBuilder.paramsBuilder();
        for (ScriptTemplate scriptTemplate : templates) {
            template.add(scriptTemplate.template());
            params.script(scriptTemplate.params());
        }
        return new ScriptTemplate(this.formatTemplate(template.toString()), params.build(), this.dataType());
    }
}

