/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.symbol;

import java.lang.invoke.MethodType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.painless.lookup.PainlessLookupUtility;
import org.objectweb.asm.commons.Method;

public class FunctionTable {
    private static final String MANGLED_FUNCTION_NAME_PREFIX = "&";
    protected Map<String, LocalFunction> localFunctions = new HashMap<String, LocalFunction>();

    public static String buildLocalFunctionKey(String functionName, int functionArity) {
        return functionName + "/" + functionArity;
    }

    public LocalFunction addFunction(String functionName, Class<?> returnType, List<Class<?>> typeParameters, boolean isInternal, boolean isStatic) {
        String functionKey = FunctionTable.buildLocalFunctionKey(functionName, typeParameters.size());
        LocalFunction function = new LocalFunction(functionName, returnType, typeParameters, isInternal, isStatic);
        this.localFunctions.put(functionKey, function);
        return function;
    }

    public LocalFunction addMangledFunction(String functionName, Class<?> returnType, List<Class<?>> typeParameters, boolean isInternal, boolean isStatic) {
        String functionKey = FunctionTable.buildLocalFunctionKey(functionName, typeParameters.size());
        LocalFunction function = new LocalFunction(functionName, MANGLED_FUNCTION_NAME_PREFIX, returnType, typeParameters, isInternal, isStatic);
        this.localFunctions.put(functionKey, function);
        return function;
    }

    public LocalFunction getFunction(String functionName, int functionArity) {
        String functionKey = FunctionTable.buildLocalFunctionKey(functionName, functionArity);
        return this.localFunctions.get(functionKey);
    }

    public LocalFunction getFunction(String functionKey) {
        return this.localFunctions.get(functionKey);
    }

    public static class LocalFunction {
        protected final String functionName;
        protected final String mangledName;
        protected final Class<?> returnType;
        protected final List<Class<?>> typeParameters;
        protected final boolean isInternal;
        protected final boolean isStatic;
        protected final MethodType methodType;
        protected final Method asmMethod;

        public LocalFunction(String functionName, Class<?> returnType, List<Class<?>> typeParameters, boolean isInternal, boolean isStatic) {
            this(functionName, "", returnType, typeParameters, isInternal, isStatic);
        }

        private LocalFunction(String functionName, String mangle, Class<?> returnType, List<Class<?>> typeParameters, boolean isInternal, boolean isStatic) {
            this.functionName = Objects.requireNonNull(functionName);
            this.mangledName = Objects.requireNonNull(mangle) + this.functionName;
            this.returnType = Objects.requireNonNull(returnType);
            this.typeParameters = List.copyOf(typeParameters);
            this.isInternal = isInternal;
            this.isStatic = isStatic;
            Class<?> javaReturnType = PainlessLookupUtility.typeToJavaType(returnType);
            Class[] javaTypeParameters = (Class[])typeParameters.stream().map(PainlessLookupUtility::typeToJavaType).toArray(Class[]::new);
            this.methodType = MethodType.methodType(javaReturnType, javaTypeParameters);
            this.asmMethod = new Method(this.mangledName, MethodType.methodType(javaReturnType, javaTypeParameters).toMethodDescriptorString());
        }

        public String getMangledName() {
            return this.mangledName;
        }

        public Class<?> getReturnType() {
            return this.returnType;
        }

        public List<Class<?>> getTypeParameters() {
            return this.typeParameters;
        }

        public boolean isInternal() {
            return this.isInternal;
        }

        public boolean isStatic() {
            return this.isStatic;
        }

        public MethodType getMethodType() {
            return this.methodType;
        }

        public Method getAsmMethod() {
            return this.asmMethod;
        }
    }
}

