/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.entitlement.runtime.policy;

import java.util.Comparator;
import org.elasticsearch.core.Strings;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;

abstract class FileAccessTreeComparison {
    private static final Logger logger = LogManager.getLogger(FileAccessTreeComparison.class);
    private final Comparator<String> pathComparator = (s1, s2) -> {
        int len1 = s1.length();
        int len2 = s2.length();
        int lim = Math.min(len1, len2);
        for (int k = 0; k < lim; ++k) {
            boolean c2IsSeparator;
            char c2;
            char c1 = s1.charAt(k);
            int comp = charComparator.compare(c1, c2 = s2.charAt(k));
            if (comp == 0) continue;
            boolean c1IsSeparator = c1 == separatorChar;
            boolean bl = c2IsSeparator = c2 == separatorChar;
            if (c1IsSeparator && c2IsSeparator) continue;
            if (c1IsSeparator) {
                return -1;
            }
            if (c2IsSeparator) {
                return 1;
            }
            return comp;
        }
        return len1 - len2;
    };
    private final char separatorChar;

    FileAccessTreeComparison(CharComparator charComparator, char separatorChar) {
        this.separatorChar = separatorChar;
    }

    Comparator<String> pathComparator() {
        return this.pathComparator;
    }

    boolean isParent(String maybeParent, String path) {
        logger.trace(() -> Strings.format((String)"checking isParent [%s] for [%s]", (Object[])new Object[]{maybeParent, path}));
        return this.pathStartsWith(path, maybeParent) && path.length() > maybeParent.length() && path.charAt(maybeParent.length()) == this.separatorChar;
    }

    boolean samePath(String currentPath, String nextPath) {
        return this.pathsAreEqual(currentPath, nextPath);
    }

    protected abstract boolean pathStartsWith(String var1, String var2);

    protected abstract boolean pathsAreEqual(String var1, String var2);

    static interface CharComparator {
        public int compare(char var1, char var2);
    }
}

