/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.core.type;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.type.EsField;
import org.elasticsearch.xpack.esql.core.util.PlanStreamInput;
import org.elasticsearch.xpack.esql.core.util.PlanStreamOutput;

public class UnsupportedEsField
extends EsField {
    private final String originalType;
    private final String inherited;

    public UnsupportedEsField(String name, String originalType) {
        this(name, originalType, null, new TreeMap<String, EsField>());
    }

    public UnsupportedEsField(String name, String originalType, String inherited, Map<String, EsField> properties) {
        super(name, DataType.UNSUPPORTED, properties, false);
        this.originalType = originalType;
        this.inherited = inherited;
    }

    public UnsupportedEsField(StreamInput in) throws IOException {
        this(PlanStreamInput.readCachedStringWithVersionCheck(in), PlanStreamInput.readCachedStringWithVersionCheck(in), in.readOptionalString(), in.readImmutableMap(EsField::readFrom));
    }

    @Override
    public void writeContent(StreamOutput out) throws IOException {
        PlanStreamOutput.writeCachedStringWithVersionCheck(out, this.getName());
        PlanStreamOutput.writeCachedStringWithVersionCheck(out, this.getOriginalType());
        out.writeOptionalString(this.getInherited());
        out.writeMap(this.getProperties(), (o, x) -> x.writeTo(out));
    }

    @Override
    public String getWriteableName() {
        return "UnsupportedEsField";
    }

    public String getOriginalType() {
        return this.originalType;
    }

    public String getInherited() {
        return this.inherited;
    }

    public boolean hasInherited() {
        return this.inherited != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        UnsupportedEsField that = (UnsupportedEsField)o;
        return Objects.equals(this.originalType, that.originalType) && Objects.equals(this.inherited, that.inherited);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.originalType, this.inherited);
    }
}

