/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.watcher.transform;

import java.io.IOException;
import java.util.Locale;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.watcher.watch.Payload;

public interface Transform
extends ToXContentObject {
    public static final ParseField TRANSFORM = new ParseField("transform", new String[0]);

    public String type();

    public static interface Builder<T extends Transform> {
        public T build();
    }

    public static abstract class Result
    implements ToXContentObject {
        private static final ParseField TYPE = new ParseField("type", new String[0]);
        private static final ParseField STATUS = new ParseField("status", new String[0]);
        private static final ParseField PAYLOAD = new ParseField("payload", new String[0]);
        private static final ParseField REASON = new ParseField("reason", new String[0]);
        protected final String type;
        protected final Status status;
        @Nullable
        protected final Payload payload;
        @Nullable
        protected final String reason;
        @Nullable
        protected final Exception exception;

        public Result(String type, Payload payload) {
            this.type = type;
            this.status = Status.SUCCESS;
            this.payload = payload;
            this.reason = null;
            this.exception = null;
        }

        public Result(String type, String reason) {
            this.type = type;
            this.status = Status.FAILURE;
            this.reason = reason;
            this.payload = null;
            this.exception = null;
        }

        public Result(String type, Exception e) {
            this.type = type;
            this.status = Status.FAILURE;
            this.reason = e.getMessage();
            this.payload = null;
            this.exception = e;
        }

        public String type() {
            return this.type;
        }

        public Status status() {
            return this.status;
        }

        public Payload payload() {
            assert (this.status == Status.SUCCESS);
            return this.payload;
        }

        public String reason() {
            assert (this.status == Status.FAILURE);
            return this.reason;
        }

        public final XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(TYPE.getPreferredName(), this.type);
            builder.field(STATUS.getPreferredName(), this.status.name().toLowerCase(Locale.ROOT));
            switch (this.status.ordinal()) {
                case 0: {
                    assert (this.exception == null);
                    builder.field(PAYLOAD.getPreferredName(), (ToXContent)this.payload, params);
                    break;
                }
                case 1: {
                    assert (this.payload == null);
                    builder.field(REASON.getPreferredName(), this.reason);
                    ElasticsearchException.generateFailureXContent((XContentBuilder)builder, (ToXContent.Params)params, (Exception)this.exception, (boolean)true);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            this.typeXContent(builder, params);
            return builder.endObject();
        }

        protected abstract XContentBuilder typeXContent(XContentBuilder var1, ToXContent.Params var2) throws IOException;

        public static enum Status {
            SUCCESS,
            FAILURE;

        }
    }
}

