/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authz.store;

import java.util.Objects;
import java.util.Set;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;

public final class RoleRetrievalResult {
    private final Set<RoleDescriptor> descriptors;
    @Nullable
    private final Exception failure;

    private RoleRetrievalResult(Set<RoleDescriptor> descriptors, @Nullable Exception failure) {
        if (descriptors != null && failure != null) {
            throw new IllegalArgumentException("either descriptors or failure must be null");
        }
        this.descriptors = descriptors;
        this.failure = failure;
    }

    public Set<RoleDescriptor> getDescriptors() {
        return this.descriptors;
    }

    @Nullable
    public Exception getFailure() {
        return this.failure;
    }

    public boolean isSuccess() {
        return this.descriptors != null;
    }

    public static RoleRetrievalResult success(Set<RoleDescriptor> descriptors) {
        Objects.requireNonNull(descriptors, "descriptors must not be null if successful");
        return new RoleRetrievalResult(descriptors, null);
    }

    public static RoleRetrievalResult failure(Exception e) {
        Objects.requireNonNull(e, "Exception must be provided");
        return new RoleRetrievalResult(null, e);
    }
}

