/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authc.ldap;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.xpack.core.security.authc.RealmSettings;
import org.elasticsearch.xpack.core.security.authc.ldap.support.LdapSearchScope;

public final class SearchGroupsResolverSettings {
    public static final Function<String, Setting.AffixSetting<String>> BASE_DN = RealmSettings.affixSetting("group_search.base_dn", key -> Setting.simpleString((String)key, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
    public static final Function<String, Setting.AffixSetting<LdapSearchScope>> SCOPE = RealmSettings.affixSetting("group_search.scope", key -> new Setting(key, (String)null, s -> LdapSearchScope.resolve(s, LdapSearchScope.SUB_TREE), new Setting.Property[]{Setting.Property.NodeScope}));
    public static final Setting.AffixSetting<String> USER_ATTRIBUTE = RealmSettings.simpleString("ldap", "group_search.user_attribute", Setting.Property.NodeScope);
    private static final String GROUP_SEARCH_DEFAULT_FILTER = "(&(|(objectclass=groupOfNames)(objectclass=groupOfUniqueNames)(objectclass=group)(objectclass=posixGroup))(|(uniqueMember={0})(member={0})(memberUid={0})))";
    public static final Setting.AffixSetting<String> FILTER = Setting.affixKeySetting((String)RealmSettings.realmSettingPrefix("ldap"), (String)"group_search.filter", key -> Setting.simpleString((String)key, (String)GROUP_SEARCH_DEFAULT_FILTER, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);

    private SearchGroupsResolverSettings() {
    }

    public static Set<Setting.AffixSetting<?>> getSettings(String realmType) {
        HashSet settings = new HashSet();
        settings.add(BASE_DN.apply(realmType));
        settings.add(SCOPE.apply(realmType));
        if (realmType.equals("ldap")) {
            settings.add(FILTER);
            settings.add(USER_ATTRIBUTE);
        }
        return settings;
    }
}

