/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.autoscaling.storage;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.allocation.AbstractAllocationDecision;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

class NodeDecision
implements ToXContentObject,
Writeable {
    private final DiscoveryNode node;
    private final Decision decision;

    NodeDecision(DiscoveryNode node, Decision decision) {
        this.node = node;
        this.decision = decision;
    }

    NodeDecision(StreamInput in) throws IOException {
        this.node = new DiscoveryNode(in);
        this.decision = Decision.readFrom((StreamInput)in);
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.node.writeTo(out);
        this.decision.writeTo(out);
    }

    DiscoveryNode node() {
        return this.node;
    }

    Decision decision() {
        return this.decision;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NodeDecision)) return false;
        NodeDecision that = (NodeDecision)o;
        if (!Objects.equals(this.node, that.node)) return false;
        if (!Objects.equals(this.decision, that.decision)) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.node, this.decision);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        AbstractAllocationDecision.discoveryNodeToXContent((DiscoveryNode)this.node, (boolean)false, (XContentBuilder)builder);
        builder.startArray("deciders");
        this.decision.toXContent(builder, params);
        builder.endArray();
        builder.endObject();
        return builder;
    }
}

