/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.planner;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.geometry.Point;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.Expressions;
import org.elasticsearch.xpack.ql.expression.FieldAttribute;
import org.elasticsearch.xpack.ql.expression.Foldables;
import org.elasticsearch.xpack.ql.expression.NamedExpression;
import org.elasticsearch.xpack.ql.expression.function.Function;
import org.elasticsearch.xpack.ql.expression.function.aggregate.AggregateFunction;
import org.elasticsearch.xpack.ql.expression.function.aggregate.Count;
import org.elasticsearch.xpack.ql.expression.function.scalar.ScalarFunction;
import org.elasticsearch.xpack.ql.expression.predicate.Range;
import org.elasticsearch.xpack.ql.expression.predicate.fulltext.MatchQueryPredicate;
import org.elasticsearch.xpack.ql.expression.predicate.fulltext.MultiMatchQueryPredicate;
import org.elasticsearch.xpack.ql.expression.predicate.fulltext.StringQueryPredicate;
import org.elasticsearch.xpack.ql.expression.predicate.logical.And;
import org.elasticsearch.xpack.ql.expression.predicate.logical.Not;
import org.elasticsearch.xpack.ql.expression.predicate.logical.Or;
import org.elasticsearch.xpack.ql.expression.predicate.nulls.IsNotNull;
import org.elasticsearch.xpack.ql.expression.predicate.nulls.IsNull;
import org.elasticsearch.xpack.ql.expression.predicate.operator.comparison.BinaryComparison;
import org.elasticsearch.xpack.ql.expression.predicate.operator.comparison.In;
import org.elasticsearch.xpack.ql.expression.predicate.operator.comparison.LessThan;
import org.elasticsearch.xpack.ql.expression.predicate.operator.comparison.LessThanOrEqual;
import org.elasticsearch.xpack.ql.expression.predicate.regex.RegexMatch;
import org.elasticsearch.xpack.ql.planner.ExpressionTranslator;
import org.elasticsearch.xpack.ql.planner.ExpressionTranslators;
import org.elasticsearch.xpack.ql.planner.TranslatorHandler;
import org.elasticsearch.xpack.ql.querydsl.query.GeoDistanceQuery;
import org.elasticsearch.xpack.ql.querydsl.query.Query;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataTypes;
import org.elasticsearch.xpack.ql.util.ReflectionUtils;
import org.elasticsearch.xpack.sql.SqlIllegalArgumentException;
import org.elasticsearch.xpack.sql.expression.function.aggregate.Avg;
import org.elasticsearch.xpack.sql.expression.function.aggregate.CompoundNumericAggregate;
import org.elasticsearch.xpack.sql.expression.function.aggregate.ExtendedStats;
import org.elasticsearch.xpack.sql.expression.function.aggregate.First;
import org.elasticsearch.xpack.sql.expression.function.aggregate.Last;
import org.elasticsearch.xpack.sql.expression.function.aggregate.MatrixStats;
import org.elasticsearch.xpack.sql.expression.function.aggregate.Max;
import org.elasticsearch.xpack.sql.expression.function.aggregate.MedianAbsoluteDeviation;
import org.elasticsearch.xpack.sql.expression.function.aggregate.Min;
import org.elasticsearch.xpack.sql.expression.function.aggregate.PercentileRanks;
import org.elasticsearch.xpack.sql.expression.function.aggregate.Percentiles;
import org.elasticsearch.xpack.sql.expression.function.aggregate.Stats;
import org.elasticsearch.xpack.sql.expression.function.aggregate.Sum;
import org.elasticsearch.xpack.sql.expression.function.aggregate.TopHits;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.DateTimeFunction;
import org.elasticsearch.xpack.sql.expression.function.scalar.geo.StDistance;
import org.elasticsearch.xpack.sql.expression.literal.geo.GeoShape;
import org.elasticsearch.xpack.sql.planner.SqlTranslatorHandler;
import org.elasticsearch.xpack.sql.querydsl.agg.AggFilter;
import org.elasticsearch.xpack.sql.querydsl.agg.AggSource;
import org.elasticsearch.xpack.sql.querydsl.agg.AndAggFilter;
import org.elasticsearch.xpack.sql.querydsl.agg.AvgAgg;
import org.elasticsearch.xpack.sql.querydsl.agg.CardinalityAgg;
import org.elasticsearch.xpack.sql.querydsl.agg.ExtendedStatsAgg;
import org.elasticsearch.xpack.sql.querydsl.agg.FilterExistsAgg;
import org.elasticsearch.xpack.sql.querydsl.agg.LeafAgg;
import org.elasticsearch.xpack.sql.querydsl.agg.MatrixStatsAgg;
import org.elasticsearch.xpack.sql.querydsl.agg.MaxAgg;
import org.elasticsearch.xpack.sql.querydsl.agg.MedianAbsoluteDeviationAgg;
import org.elasticsearch.xpack.sql.querydsl.agg.MinAgg;
import org.elasticsearch.xpack.sql.querydsl.agg.OrAggFilter;
import org.elasticsearch.xpack.sql.querydsl.agg.PercentileRanksAgg;
import org.elasticsearch.xpack.sql.querydsl.agg.PercentilesAgg;
import org.elasticsearch.xpack.sql.querydsl.agg.StatsAgg;
import org.elasticsearch.xpack.sql.querydsl.agg.SumAgg;
import org.elasticsearch.xpack.sql.querydsl.agg.TopHitsAgg;
import org.elasticsearch.xpack.sql.type.SqlDataTypeConverter;
import org.elasticsearch.xpack.sql.util.Check;

final class QueryTranslator {
    public static final String DATE_FORMAT = "strict_date_optional_time_nanos";
    public static final String TIME_FORMAT = "strict_hour_minute_second_fraction";
    private static final List<SqlExpressionTranslator<?>> QUERY_TRANSLATORS = Arrays.asList(new BinaryComparisons(), new InComparisons(), new Ranges(), new BinaryLogic(), new Nots(), new IsNullTranslator(), new IsNotNullTranslator(), new Likes(), new StringQueries(), new Matches(), new MultiMatches(), new Scalars());
    private static final List<AggTranslator<?>> AGG_TRANSLATORS = Arrays.asList(new Maxes(), new Mins(), new Avgs(), new Sums(), new StatsAggs(), new ExtendedStatsAggs(), new MatrixStatsAggs(), new PercentilesAggs(), new PercentileRanksAggs(), new CountAggs(), new DateTimes(), new Firsts(), new Lasts(), new MADs());

    private QueryTranslator() {
    }

    static QueryTranslation toQuery(Expression e, boolean onAggs) {
        QueryTranslation translation = null;
        SqlTranslatorHandler handler = new SqlTranslatorHandler(onAggs);
        for (SqlExpressionTranslator<?> translator : QUERY_TRANSLATORS) {
            translation = translator.translate(e, onAggs, handler);
            if (translation == null) continue;
            return translation;
        }
        throw new SqlIllegalArgumentException("Don't know how to translate {} {}", e.nodeName(), e);
    }

    static LeafAgg toAgg(String id, Function f) {
        for (AggTranslator<?> translator : AGG_TRANSLATORS) {
            LeafAgg agg = translator.apply(id, f);
            if (agg == null) continue;
            return agg;
        }
        throw new SqlIllegalArgumentException("Don't know how to translate {} {}", f.nodeName(), f);
    }

    static QueryTranslation and(Source source, QueryTranslation left, QueryTranslation right) {
        Check.isTrue(left != null || right != null, "Both expressions are null");
        if (left == null) {
            return right;
        }
        if (right == null) {
            return left;
        }
        Query newQ = null;
        if (left.query != null || right.query != null) {
            newQ = ExpressionTranslators.and((Source)source, (Query)left.query, (Query)right.query);
        }
        AggFilter aggFilter = left.aggFilter == null ? right.aggFilter : (right.aggFilter == null ? left.aggFilter : new AndAggFilter(left.aggFilter, right.aggFilter));
        return new QueryTranslation(newQ, aggFilter);
    }

    static QueryTranslation or(Source source, QueryTranslation left, QueryTranslation right) {
        Check.isTrue(left != null || right != null, "Both expressions are null");
        if (left == null) {
            return right;
        }
        if (right == null) {
            return left;
        }
        Query newQ = null;
        if (left.query != null || right.query != null) {
            newQ = ExpressionTranslators.or((Source)source, (Query)left.query, (Query)right.query);
        }
        AggFilter aggFilter = null;
        aggFilter = left.aggFilter == null ? right.aggFilter : (right.aggFilter == null ? left.aggFilter : new OrAggFilter(left.aggFilter, right.aggFilter));
        return new QueryTranslation(newQ, aggFilter);
    }

    static String nameOf(Expression e) {
        if (e instanceof DateTimeFunction) {
            DateTimeFunction dateTimeFunction = (DateTimeFunction)e;
            return QueryTranslator.nameOf(dateTimeFunction.field());
        }
        if (e instanceof NamedExpression) {
            NamedExpression namedExpression = (NamedExpression)e;
            return namedExpression.name();
        }
        return e.sourceText();
    }

    static String field(AggregateFunction af, Expression arg) {
        if (arg.foldable()) {
            return String.valueOf(arg.fold());
        }
        if (arg instanceof FieldAttribute) {
            FieldAttribute field = (FieldAttribute)arg;
            if (af instanceof Count && ((Count)af).distinct() || af instanceof TopHits) {
                return field.exactAttribute().name();
            }
            return field.name();
        }
        throw new SqlIllegalArgumentException("Does not know how to convert argument {} for function {}", arg.nodeString(), af.nodeString());
    }

    private static boolean isFieldOrLiteral(Expression e) {
        return e.foldable() || e instanceof FieldAttribute;
    }

    private static AggSource asFieldOrLiteralOrScript(AggregateFunction af) {
        return QueryTranslator.asFieldOrLiteralOrScript(af, af.field());
    }

    private static AggSource asFieldOrLiteralOrScript(AggregateFunction af, Expression e) {
        if (e == null) {
            return null;
        }
        return QueryTranslator.isFieldOrLiteral(e) ? AggSource.of(QueryTranslator.field(af, e)) : AggSource.of(((ScalarFunction)e).asScript());
    }

    private static List<Double> foldAndConvertToDoubles(List<Expression> list) {
        ArrayList<Double> values = new ArrayList<Double>(list.size());
        for (Expression e : list) {
            values.add((Double)SqlDataTypeConverter.convert(Foldables.valueOf((Expression)e), DataTypes.DOUBLE));
        }
        return values;
    }

    static abstract class SqlExpressionTranslator<E extends Expression> {
        private final Class<E> typeToken = ReflectionUtils.detectSuperTypeForRuleLike(this.getClass());

        SqlExpressionTranslator() {
        }

        public QueryTranslation translate(Expression exp, boolean onAggs, TranslatorHandler handler) {
            return this.typeToken.isInstance(exp) ? this.asQuery(exp, onAggs, handler) : null;
        }

        protected abstract QueryTranslation asQuery(E var1, boolean var2, TranslatorHandler var3);
    }

    static class QueryTranslation {
        final Query query;
        final AggFilter aggFilter;

        QueryTranslation(Query query) {
            this(query, null);
        }

        QueryTranslation(Query query, AggFilter aggFilter) {
            this.query = query;
            this.aggFilter = aggFilter;
        }
    }

    static abstract class AggTranslator<F extends Function> {
        private final Class<?> typeToken = ReflectionUtils.detectSuperTypeForRuleLike(this.getClass());

        AggTranslator() {
        }

        public final LeafAgg apply(String id, Function f) {
            return this.typeToken.isInstance(f) ? this.asAgg(id, f) : null;
        }

        protected abstract LeafAgg asAgg(String var1, F var2);
    }

    static class BinaryComparisons
    extends SqlExpressionTranslator<BinaryComparison> {
        BinaryComparisons() {
        }

        @Override
        protected QueryTranslation asQuery(BinaryComparison bc, boolean onAggs, TranslatorHandler handler) {
            ExpressionTranslators.BinaryComparisons.checkBinaryComparison((BinaryComparison)bc);
            Query query = null;
            AggFilter aggFilter = null;
            if (onAggs) {
                aggFilter = new AggFilter(Expressions.id((Expression)bc.left()), bc.asScript());
            } else {
                query = BinaryComparisons.translateQuery(bc, handler);
            }
            return new QueryTranslation(query, aggFilter);
        }

        private static Query translateQuery(BinaryComparison bc, TranslatorHandler handler) {
            Geometry geometry;
            Object geoShape;
            StDistance stDistance;
            Source source = bc.source();
            Object value = Foldables.valueOf((Expression)bc.right());
            if (bc.left() instanceof StDistance && value instanceof Number && (bc instanceof LessThan || bc instanceof LessThanOrEqual) && (stDistance = (StDistance)bc.left()).left() instanceof FieldAttribute && stDistance.right().foldable() && (geoShape = Foldables.valueOf((Expression)stDistance.right())) instanceof GeoShape && (geometry = ((GeoShape)geoShape).toGeometry()) instanceof Point) {
                String field = QueryTranslator.nameOf(stDistance.left());
                GeoDistanceQuery query = new GeoDistanceQuery(source, field, ((Number)value).doubleValue(), ((Point)geometry).getY(), ((Point)geometry).getX());
                return ExpressionTranslator.wrapIfNested((Query)query, (Expression)stDistance.left());
            }
            return ExpressionTranslators.BinaryComparisons.doTranslate((BinaryComparison)bc, (TranslatorHandler)handler);
        }
    }

    static class InComparisons
    extends SqlExpressionTranslator<org.elasticsearch.xpack.sql.expression.predicate.operator.comparison.In> {
        InComparisons() {
        }

        @Override
        protected QueryTranslation asQuery(org.elasticsearch.xpack.sql.expression.predicate.operator.comparison.In in, boolean onAggs, TranslatorHandler handler) {
            Query query = null;
            AggFilter aggFilter = null;
            if (onAggs) {
                aggFilter = new AggFilter(Expressions.id((Expression)in.value()), in.asScript());
            } else {
                query = ExpressionTranslators.InComparisons.doTranslate((In)in, (TranslatorHandler)handler);
            }
            return new QueryTranslation(query, aggFilter);
        }
    }

    static class Ranges
    extends SqlExpressionTranslator<Range> {
        Ranges() {
        }

        @Override
        protected QueryTranslation asQuery(Range r, boolean onAggs, TranslatorHandler handler) {
            Expression e = r.value();
            Query query = null;
            AggFilter aggFilter = null;
            if (onAggs) {
                aggFilter = new AggFilter(Expressions.id((Expression)e), r.asScript());
            } else {
                query = ExpressionTranslators.Ranges.doTranslate((Range)r, (TranslatorHandler)handler);
            }
            return new QueryTranslation(query, aggFilter);
        }
    }

    static class BinaryLogic
    extends SqlExpressionTranslator<org.elasticsearch.xpack.ql.expression.predicate.logical.BinaryLogic> {
        BinaryLogic() {
        }

        @Override
        protected QueryTranslation asQuery(org.elasticsearch.xpack.ql.expression.predicate.logical.BinaryLogic e, boolean onAggs, TranslatorHandler handler) {
            if (e instanceof And) {
                return QueryTranslator.and(e.source(), QueryTranslator.toQuery(e.left(), onAggs), QueryTranslator.toQuery(e.right(), onAggs));
            }
            if (e instanceof Or) {
                return QueryTranslator.or(e.source(), QueryTranslator.toQuery(e.left(), onAggs), QueryTranslator.toQuery(e.right(), onAggs));
            }
            return null;
        }
    }

    static class Nots
    extends SqlExpressionTranslator<Not> {
        Nots() {
        }

        @Override
        protected QueryTranslation asQuery(Not not, boolean onAggs, TranslatorHandler handler) {
            Query query = null;
            AggFilter aggFilter = null;
            if (onAggs) {
                aggFilter = new AggFilter(Expressions.id((Expression)not), not.asScript());
            } else {
                query = ExpressionTranslators.Nots.doTranslate((Not)not, (TranslatorHandler)handler);
            }
            return new QueryTranslation(query, aggFilter);
        }
    }

    static class IsNullTranslator
    extends SqlExpressionTranslator<IsNull> {
        IsNullTranslator() {
        }

        @Override
        protected QueryTranslation asQuery(IsNull isNull, boolean onAggs, TranslatorHandler handler) {
            Query query = null;
            AggFilter aggFilter = null;
            if (onAggs) {
                aggFilter = new AggFilter(Expressions.id((Expression)isNull), isNull.asScript());
            } else {
                query = ExpressionTranslators.IsNulls.doTranslate((IsNull)isNull, (TranslatorHandler)handler);
            }
            return new QueryTranslation(query, aggFilter);
        }
    }

    static class IsNotNullTranslator
    extends SqlExpressionTranslator<IsNotNull> {
        IsNotNullTranslator() {
        }

        @Override
        protected QueryTranslation asQuery(IsNotNull isNotNull, boolean onAggs, TranslatorHandler handler) {
            Query query = null;
            AggFilter aggFilter = null;
            if (onAggs) {
                aggFilter = new AggFilter(Expressions.id((Expression)isNotNull), isNotNull.asScript());
            } else {
                query = ExpressionTranslators.IsNotNulls.doTranslate((IsNotNull)isNotNull, (TranslatorHandler)handler);
            }
            return new QueryTranslation(query, aggFilter);
        }
    }

    static class Likes
    extends SqlExpressionTranslator<RegexMatch> {
        Likes() {
        }

        @Override
        protected QueryTranslation asQuery(RegexMatch e, boolean onAggs, TranslatorHandler handler) {
            Check.isTrue(!onAggs, "Like not supported within an aggregation context");
            return new QueryTranslation(ExpressionTranslators.Likes.doTranslate((RegexMatch)e, (TranslatorHandler)handler));
        }
    }

    static class StringQueries
    extends SqlExpressionTranslator<StringQueryPredicate> {
        StringQueries() {
        }

        @Override
        protected QueryTranslation asQuery(StringQueryPredicate q, boolean onAggs, TranslatorHandler handler) {
            Check.isTrue(!onAggs, "Like not supported within an aggregation context");
            return new QueryTranslation(ExpressionTranslators.StringQueries.doTranslate((StringQueryPredicate)q, (TranslatorHandler)handler));
        }
    }

    static class Matches
    extends SqlExpressionTranslator<MatchQueryPredicate> {
        Matches() {
        }

        @Override
        protected QueryTranslation asQuery(MatchQueryPredicate q, boolean onAggs, TranslatorHandler handler) {
            Check.isTrue(!onAggs, "Like not supported within an aggregation context");
            return new QueryTranslation(ExpressionTranslators.Matches.doTranslate((MatchQueryPredicate)q, (TranslatorHandler)handler));
        }
    }

    static class MultiMatches
    extends SqlExpressionTranslator<MultiMatchQueryPredicate> {
        MultiMatches() {
        }

        @Override
        protected QueryTranslation asQuery(MultiMatchQueryPredicate q, boolean onAggs, TranslatorHandler handler) {
            Check.isTrue(!onAggs, "Like not supported within an aggregation context");
            return new QueryTranslation(ExpressionTranslators.MultiMatches.doTranslate((MultiMatchQueryPredicate)q, (TranslatorHandler)handler));
        }
    }

    static class Scalars
    extends SqlExpressionTranslator<ScalarFunction> {
        Scalars() {
        }

        @Override
        protected QueryTranslation asQuery(ScalarFunction f, boolean onAggs, TranslatorHandler handler) {
            Query query = null;
            AggFilter aggFilter = null;
            if (onAggs) {
                aggFilter = new AggFilter(Expressions.id((Expression)f), f.asScript());
            } else {
                query = ExpressionTranslators.Scalars.doTranslate((ScalarFunction)f, (TranslatorHandler)handler);
            }
            return new QueryTranslation(query, aggFilter);
        }
    }

    static class Maxes
    extends SingleValueAggTranslator<Max> {
        Maxes() {
        }

        @Override
        protected LeafAgg toAgg(String id, Max m) {
            return new MaxAgg(id, QueryTranslator.asFieldOrLiteralOrScript(m));
        }
    }

    static class Mins
    extends SingleValueAggTranslator<Min> {
        Mins() {
        }

        @Override
        protected LeafAgg toAgg(String id, Min m) {
            return new MinAgg(id, QueryTranslator.asFieldOrLiteralOrScript(m));
        }
    }

    static class Avgs
    extends SingleValueAggTranslator<Avg> {
        Avgs() {
        }

        @Override
        protected LeafAgg toAgg(String id, Avg a) {
            return new AvgAgg(id, QueryTranslator.asFieldOrLiteralOrScript(a));
        }
    }

    static class Sums
    extends SingleValueAggTranslator<Sum> {
        Sums() {
        }

        @Override
        protected LeafAgg toAgg(String id, Sum s) {
            return new SumAgg(id, QueryTranslator.asFieldOrLiteralOrScript(s));
        }
    }

    static class StatsAggs
    extends CompoundAggTranslator<Stats> {
        StatsAggs() {
        }

        @Override
        protected LeafAgg toAgg(String id, Stats s) {
            return new StatsAgg(id, QueryTranslator.asFieldOrLiteralOrScript(s));
        }
    }

    static class ExtendedStatsAggs
    extends CompoundAggTranslator<ExtendedStats> {
        ExtendedStatsAggs() {
        }

        @Override
        protected LeafAgg toAgg(String id, ExtendedStats e) {
            return new ExtendedStatsAgg(id, QueryTranslator.asFieldOrLiteralOrScript(e));
        }
    }

    static class MatrixStatsAggs
    extends CompoundAggTranslator<MatrixStats> {
        MatrixStatsAggs() {
        }

        @Override
        protected LeafAgg toAgg(String id, MatrixStats m) {
            if (QueryTranslator.isFieldOrLiteral(m.field())) {
                return new MatrixStatsAgg(id, Collections.singletonList(QueryTranslator.field(m, m.field())));
            }
            throw new SqlIllegalArgumentException("Cannot use scalar functions or operators: [{}] in aggregate functions [KURTOSIS] and [SKEWNESS]", m.field().toString());
        }
    }

    static class PercentilesAggs
    extends CompoundAggTranslator<Percentiles> {
        PercentilesAggs() {
        }

        @Override
        protected LeafAgg toAgg(String id, Percentiles p) {
            return new PercentilesAgg(id, QueryTranslator.asFieldOrLiteralOrScript(p), QueryTranslator.foldAndConvertToDoubles(p.percents()), p.percentilesConfig());
        }
    }

    static class PercentileRanksAggs
    extends CompoundAggTranslator<PercentileRanks> {
        PercentileRanksAggs() {
        }

        @Override
        protected LeafAgg toAgg(String id, PercentileRanks p) {
            return new PercentileRanksAgg(id, QueryTranslator.asFieldOrLiteralOrScript(p), QueryTranslator.foldAndConvertToDoubles(p.values()), p.percentilesConfig());
        }
    }

    static class CountAggs
    extends SingleValueAggTranslator<Count> {
        CountAggs() {
        }

        @Override
        protected LeafAgg toAgg(String id, Count c) {
            if (c.distinct()) {
                return new CardinalityAgg(id, QueryTranslator.asFieldOrLiteralOrScript((AggregateFunction)c));
            }
            return new FilterExistsAgg(id, QueryTranslator.asFieldOrLiteralOrScript((AggregateFunction)c));
        }
    }

    static class DateTimes
    extends SingleValueAggTranslator<Min> {
        DateTimes() {
        }

        @Override
        protected LeafAgg toAgg(String id, Min m) {
            return new MinAgg(id, QueryTranslator.asFieldOrLiteralOrScript(m));
        }
    }

    static class Firsts
    extends TopHitsAggTranslator<First> {
        Firsts() {
        }

        @Override
        protected LeafAgg toAgg(String id, First f) {
            return new TopHitsAgg(id, QueryTranslator.asFieldOrLiteralOrScript(f, f.field()), f.dataType(), QueryTranslator.asFieldOrLiteralOrScript(f, f.orderField()), f.orderField() == null ? null : f.orderField().dataType(), SortOrder.ASC);
        }
    }

    static class Lasts
    extends TopHitsAggTranslator<Last> {
        Lasts() {
        }

        @Override
        protected LeafAgg toAgg(String id, Last l) {
            return new TopHitsAgg(id, QueryTranslator.asFieldOrLiteralOrScript(l, l.field()), l.dataType(), QueryTranslator.asFieldOrLiteralOrScript(l, l.orderField()), l.orderField() == null ? null : l.orderField().dataType(), SortOrder.DESC);
        }
    }

    static class MADs
    extends SingleValueAggTranslator<MedianAbsoluteDeviation> {
        MADs() {
        }

        @Override
        protected LeafAgg toAgg(String id, MedianAbsoluteDeviation m) {
            return new MedianAbsoluteDeviationAgg(id, QueryTranslator.asFieldOrLiteralOrScript(m));
        }
    }

    static abstract class TopHitsAggTranslator<C extends TopHits>
    extends AggTranslator<C> {
        TopHitsAggTranslator() {
        }

        @Override
        protected final LeafAgg asAgg(String id, C function) {
            return this.toAgg(id, function);
        }

        protected abstract LeafAgg toAgg(String var1, C var2);
    }

    static abstract class CompoundAggTranslator<C extends CompoundNumericAggregate>
    extends AggTranslator<C> {
        CompoundAggTranslator() {
        }

        @Override
        protected final LeafAgg asAgg(String id, C function) {
            return this.toAgg(id, function);
        }

        protected abstract LeafAgg toAgg(String var1, C var2);
    }

    static abstract class SingleValueAggTranslator<F extends Function>
    extends AggTranslator<F> {
        SingleValueAggTranslator() {
        }

        @Override
        protected final LeafAgg asAgg(String id, F function) {
            return this.toAgg(id, function);
        }

        protected abstract LeafAgg toAgg(String var1, F var2);
    }
}

