/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.plan.physical;

import java.util.List;
import java.util.Objects;
import org.elasticsearch.xpack.ql.expression.Order;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.sql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.sql.plan.physical.UnaryExec;
import org.elasticsearch.xpack.sql.plan.physical.Unexecutable;

public class OrderExec
extends UnaryExec
implements Unexecutable {
    private final List<Order> order;

    public OrderExec(Source source, PhysicalPlan child, List<Order> order) {
        super(source, child);
        this.order = order;
    }

    protected NodeInfo<OrderExec> info() {
        return NodeInfo.create((Node)this, OrderExec::new, (Object)this.child(), this.order);
    }

    @Override
    protected OrderExec replaceChild(PhysicalPlan newChild) {
        return new OrderExec(this.source(), newChild, this.order);
    }

    public List<Order> order() {
        return this.order;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.order, this.child());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        OrderExec other = (OrderExec)obj;
        return Objects.equals(this.order, other.order) && Objects.equals(this.child(), other.child());
    }
}

