/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.string;

import java.util.Locale;
import java.util.Objects;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.FieldAttribute;
import org.elasticsearch.xpack.ql.expression.TypeResolutions;
import org.elasticsearch.xpack.ql.expression.function.scalar.UnaryScalarFunction;
import org.elasticsearch.xpack.ql.expression.gen.processor.Processor;
import org.elasticsearch.xpack.ql.expression.gen.script.ParamsBuilder;
import org.elasticsearch.xpack.ql.expression.gen.script.ScriptTemplate;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.sql.expression.function.scalar.string.StringProcessor;

public abstract class UnaryStringIntFunction
extends UnaryScalarFunction {
    protected UnaryStringIntFunction(Source source, Expression field) {
        super(source, field);
    }

    public boolean foldable() {
        return this.field().foldable();
    }

    public Object fold() {
        return this.operation().apply(this.field().fold());
    }

    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        return TypeResolutions.isInteger((Expression)this.field(), (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.DEFAULT);
    }

    protected Processor makeProcessor() {
        return new StringProcessor(this.operation());
    }

    protected abstract StringProcessor.StringOperation operation();

    public ScriptTemplate scriptWithField(FieldAttribute field) {
        return new ScriptTemplate(this.processScript("doc[{}].value"), ParamsBuilder.paramsBuilder().variable((Object)field.name()).build(), this.dataType());
    }

    public String processScript(String template) {
        return super.processScript(String.format(Locale.ROOT, "{sql}.%s(%s)", this.operation().toString().toLowerCase(Locale.ROOT), template));
    }

    public int hashCode() {
        return Objects.hash(this.field());
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        UnaryStringIntFunction other = (UnaryStringIntFunction)((Object)obj);
        return Objects.equals(other.field(), this.field());
    }
}

